(()=>{"use strict";var e={240:(e,t,a)=>{a.d(t,{$:()=>n,ConfigManager:()=>o});const s={development:{name:"development",baseUrl:"http://localhost:8000",frontend:{manager:"http://localhost:3100",hunter:"http://localhost:3000"},apiVersion:"v1",debug:!0,endpoints:{auth:{register:"/api/v1/chrome/auth/register",login:"/api/v1/chrome/auth/login",verify:"/api/v1/chrome/auth/verify",refresh:"/api/v1/chrome/auth/refresh",logout:"/api/v1/chrome/auth/logout",status:"/api/v1/chrome/auth/status",mfa:{status:"/api/v1/chrome/auth/mfa/status",enroll:"/api/v1/chrome/auth/mfa/enroll",challenge:"/api/v1/chrome/auth/mfa/challenge",verify:"/api/v1/chrome/auth/mfa/verify",factors:"/api/v1/chrome/auth/mfa/factors",unenroll:"/api/v1/chrome/auth/mfa/unenroll"}},data:{capture:{page:"/api/v1/chrome/capture/page"},bookmarks:"/api/v1/chrome/bookmarks",settings:"/api/v1/chrome/settings",sync:"/api/v1/chrome/sync"},investigations:{bulkData:"/api/v1/chrome/investigations/bulk-data",urls:"/api/v1/chrome/investigations/urls",iocs:"/api/v1/chrome/investigations/iocs",screenshots:"/api/v1/chrome/investigations/screenshots",notes:"/api/v1/chrome/investigations/notes"},aiAgents:{threatIntel:"/api/v1/chrome/ai-agents/threat-intel",osint:"/api/v1/chrome/ai-agents/osint",forensics:"/api/v1/chrome/ai-agents/forensics"},selectorSearch:{create:"/api/v1/selector-search",list:"/api/v1/selector-search",get:"/api/v1/selector-search/{id}"}}},production:{name:"production",baseUrl:"https://test005.api.edgerun.org",frontend:{manager:"https://test005.jan.edgerun.org",hunter:"https://test005.hunter.edgerun.org"},apiVersion:"v1",debug:!1,endpoints:{auth:{register:"/api/v1/chrome/auth/register",login:"/api/v1/chrome/auth/login",verify:"/api/v1/chrome/auth/verify",refresh:"/api/v1/chrome/auth/refresh",logout:"/api/v1/chrome/auth/logout",status:"/api/v1/chrome/auth/status",mfa:{status:"/api/v1/chrome/auth/mfa/status",enroll:"/api/v1/chrome/auth/mfa/enroll",challenge:"/api/v1/chrome/auth/mfa/challenge",verify:"/api/v1/chrome/auth/mfa/verify",factors:"/api/v1/chrome/auth/mfa/factors",unenroll:"/api/v1/chrome/auth/mfa/unenroll"}},data:{capture:{page:"/api/v1/chrome/capture/page"},bookmarks:"/api/v1/chrome/bookmarks",settings:"/api/v1/chrome/settings",sync:"/api/v1/chrome/sync"},investigations:{bulkData:"/api/v1/chrome/investigations/bulk-data",urls:"/api/v1/chrome/investigations/urls",iocs:"/api/v1/chrome/investigations/iocs",screenshots:"/api/v1/chrome/investigations/screenshots",notes:"/api/v1/chrome/investigations/notes"},aiAgents:{threatIntel:"/api/v1/chrome/ai-agents/threat-intel",osint:"/api/v1/chrome/ai-agents/osint",forensics:"/api/v1/chrome/ai-agents/forensics"},selectorSearch:{create:"/api/v1/selector-search",list:"/api/v1/selector-search",get:"/api/v1/selector-search/{id}"}}},staging:{name:"staging",baseUrl:"https://staging-api.larvitar.com",frontend:{manager:"https://staging-jan.larvitar.com",hunter:"https://staging-hunter.larvitar.com"},apiVersion:"v1",debug:!0,endpoints:{auth:{register:"/api/v1/chrome/auth/register",login:"/api/v1/chrome/auth/login",verify:"/api/v1/chrome/auth/verify",refresh:"/api/v1/chrome/auth/refresh",logout:"/api/v1/chrome/auth/logout",status:"/api/v1/chrome/auth/status",mfa:{status:"/api/v1/chrome/auth/mfa/status",enroll:"/api/v1/chrome/auth/mfa/enroll",challenge:"/api/v1/chrome/auth/mfa/challenge",verify:"/api/v1/chrome/auth/mfa/verify",factors:"/api/v1/chrome/auth/mfa/factors",unenroll:"/api/v1/chrome/auth/mfa/unenroll"}},data:{capture:{page:"/api/v1/chrome/capture/page"},bookmarks:"/api/v1/chrome/bookmarks",settings:"/api/v1/chrome/settings",sync:"/api/v1/chrome/sync"},investigations:{bulkData:"/api/v1/chrome/investigations/bulk-data",urls:"/api/v1/chrome/investigations/urls",iocs:"/api/v1/chrome/investigations/iocs",screenshots:"/api/v1/chrome/investigations/screenshots",notes:"/api/v1/chrome/investigations/notes"},aiAgents:{threatIntel:"/api/v1/chrome/ai-agents/threat-intel",osint:"/api/v1/chrome/ai-agents/osint",forensics:"/api/v1/chrome/ai-agents/forensics"},selectorSearch:{create:"/api/v1/selector-search",list:"/api/v1/selector-search",get:"/api/v1/selector-search/{id}"}}}},n={environment:s.production,extension:{name:"Larvitar Security Extension",version:"1.0.0",id:chrome?.runtime?.id},storage:{keys:{accessToken:"larvitar_access_token",refreshToken:"larvitar_refresh_token",sessionId:"larvitar_session_id",user:"larvitar_user",expiresAt:"larvitar_expires_at"}},security:{tokenRefreshThreshold:1,maxRetries:3,timeout:3e4}};class o{static getBaseUrl(){return this.baseUrlOverride||n.environment.baseUrl}static getFrontendUrl(e){return n.environment.frontend[e]}static getApiUrl(e){const t=e.split(".");let a=n.environment.endpoints;for(const s of t){if("object"!=typeof a||null===a)throw new Error(`Invalid endpoint path: ${e}`);a=a[s]}if("string"!=typeof a)throw new Error(`Endpoint not found: ${e}`);return`${this.getBaseUrl()}${a}`}static getDataApiUrl(e){return this.getApiUrl(`data.${e}`)}static getInvestigationApiUrl(e){return this.getApiUrl(`investigations.${e}`)}static getAiAgentApiUrl(e){return this.getApiUrl(`aiAgents.${e}`)}static getSelectorSearchApiUrl(e,t){const a=this.getApiUrl(`selectorSearch.${e}`);return"get"===e&&t?a.replace("{id}",t):a}static getFullApiUrl(e){return`${this.getBaseUrl()}${e}`}static isDebugMode(){return n.environment.debug}static getEnvironmentName(){return n.environment.name}static getEnvironmentDefaults(e){return s[e]}static isUsingCustomBaseUrl(){return"string"==typeof this.baseUrlOverride&&this.baseUrlOverride.length>0}static async setCustomBaseUrl(e){const t=(e||"").trim();if(!/^https?:\/\//i.test(t))throw new Error("Invalid URL. Must start with http:// or https://");const a=t.replace(/\/$/,"");this.baseUrlOverride=a,"undefined"!=typeof chrome&&chrome.storage&&await chrome.storage.local.set({larvitar_custom_base_url:a}),this.log("info",`Custom base URL set: ${a}`);try{chrome.runtime?.sendMessage?.({type:"configUpdated",payload:{baseUrl:a}})}catch{}}static async clearCustomBaseUrl(){this.baseUrlOverride=null,"undefined"!=typeof chrome&&chrome.storage&&await chrome.storage.local.remove("larvitar_custom_base_url"),this.log("info","Custom base URL cleared");try{chrome.runtime?.sendMessage?.({type:"configUpdated",payload:{baseUrl:n.environment.baseUrl}})}catch{}}static log(e,t,...a){if(!this.isDebugMode()&&"info"===e)return;const s=`[Larvitar-${e.toUpperCase()}]`;switch(e){case"info":console.log(s,t,...a);break;case"warn":console.warn(s,t,...a);break;case"error":console.error(s,t,...a)}}static async switchEnvironment(e){const t=s[e];if(!t)throw new Error(`Unknown environment: ${e}`);n.environment=t,"undefined"!=typeof chrome&&chrome.storage&&await chrome.storage.local.set({larvitar_environment:e}),this.log("info",`Switched to ${e} environment`)}static async loadEnvironmentPreference(){if("undefined"!=typeof chrome&&chrome.storage)try{const e=await chrome.storage.local.get(["larvitar_environment","larvitar_custom_base_url"]);e.larvitar_environment&&s[e.larvitar_environment]&&(n.environment=s[e.larvitar_environment],this.log("info",`Loaded environment preference: ${e.larvitar_environment}`)),"string"==typeof e.larvitar_custom_base_url&&e.larvitar_custom_base_url.length>0&&(this.baseUrlOverride=e.larvitar_custom_base_url,this.log("info",`Loaded custom base URL override: ${this.baseUrlOverride}`))}catch(e){this.log("warn","Failed to load environment preference:",e)}}static getHeaders(e=!1){return{"Content-Type":"application/json","X-Extension-ID":n.extension.id||"unknown","X-Extension-Version":n.extension.version}}}o.baseUrlOverride=null,"undefined"!=typeof chrome&&chrome.storage&&o.loadEnvironmentPreference().catch(e=>{o.log("warn","Failed to auto-load environment preference:",e)})},366:(e,t,a)=>{a.d(t,{BX:()=>o,Dr:()=>n,lR:()=>s});class s extends Error{constructor(e,t,a){super(e),this.name="AuthError",this.code=t,this.statusCode=a}}class n extends Error{constructor(e,t){super(e),this.name="NetworkError",this.statusCode=t}}class o extends s{constructor(){super("Authentication token has expired","TOKEN_EXPIRED",401),this.name="TokenExpiredError"}}},892:(e,t,a)=>{a.d(t,{getStorageData:()=>r,setStorageData:()=>i,u:()=>n});const s={isExtensionEnabled:!0,userPreferences:{},lastUpdateTime:Date.now()};async function n(){console.log("[Storage] Initializing storage feature");try{const e=await chrome.storage.sync.get(Object.keys(s));Object.keys(e).length>0||(await chrome.storage.sync.set(s),console.log("[Storage] Default storage data initialized")),chrome.storage.onChanged.addListener(o),console.log("[Storage] Storage feature initialized successfully")}catch(e){throw console.error("[Storage] Error initializing storage feature:",e),e}}function o(e,t){if(console.log("[Storage] Storage changed:",{changes:e,areaName:t}),e.isExtensionEnabled){const t=e.isExtensionEnabled.newValue;console.log("[Storage] Extension enabled status changed:",t)}}async function r(e){try{return await chrome.storage.sync.get(e)}catch(e){throw console.error("[Storage] Error getting storage data:",e),e}}async function i(e){try{await chrome.storage.sync.set(e),console.log("[Storage] Storage data updated:",e)}catch(e){throw console.error("[Storage] Error setting storage data:",e),e}}},908:(e,t,a)=>{a.d(t,{dataManager:()=>c,C:()=>l});var s=a(943),n=a(240);class o extends Error{constructor(e,t,a,s){super(e),this.code=t,this.statusCode=a,this.details=s,this.name="DataCaptureError"}}class r extends Error{constructor(e,t,a,s){super(e),this.syncType=t,this.itemsAffected=a,this.retryable=s,this.name="SyncError"}}Error,a(366);class i{constructor(e){this.auditLog=[],this.authManager=e}async capturePage(e){try{n.ConfigManager.log("info","Starting page capture",{url:e.url}),await this.addAuditLogEntry({action:"page_capture_initiated",resource_type:"page",details:{url:e.url,is_suspicious:e.is_suspicious,auto_capture:e.metadata?.auto_capture||!1}});const t=e.investigation_id||s.workSessionManager?.getCurrentInvestigationId()||void 0,a={url:e.url,title:e.title||"Untitled Page",content:e.content,meta_description:e.meta_description,keywords:e.keywords,timestamp:e.timestamp||(new Date).toISOString(),user_id:await this.getCurrentUserId(),investigation_id:t,auto_capture:e.metadata?.auto_capture||!1};n.ConfigManager.log("info","Sending page capture request",{url:a.url,title:a.title,hasContent:!!a.content,hasMetaDescription:!!a.meta_description,keywordsCount:a.keywords?.length||0});const r=await this.authManager.makeAuthenticatedRequest(n.ConfigManager.getDataApiUrl("capture.page"),{method:"POST",body:JSON.stringify(a)});if(!r.ok){const e=await r.json();throw new o(e.detail||"Page capture failed",e.code,r.status,e)}const i=await r.json();return await this.addAuditLogEntry({action:"page_capture_completed",resource_type:"page",resource_id:i.id,details:{url:e.url,evidence_id:i.evidence_id,status:i.status}}),n.ConfigManager.log("info","Page capture successful",{captureId:i.id,evidenceId:i.evidence_id}),i}catch(t){if(n.ConfigManager.log("error","Page capture error:",t),await this.addAuditLogEntry({action:"page_capture_failed",resource_type:"page",details:{url:e.url,error:t instanceof Error?t.message:String(t)}}),t instanceof o)throw t;throw new o("Page capture failed","CAPTURE_ERROR")}}async createBookmark(e){try{n.ConfigManager.log("info","Creating bookmark",{url:e.url}),await this.addAuditLogEntry({action:"bookmark_created",resource_type:"bookmark",details:{url:e.url,threat_level:e.metadata?.threat_level,tags:e.tags}});const t={...e,timestamp:e.timestamp||Date.now()},a=await this.authManager.makeAuthenticatedRequest(n.ConfigManager.getDataApiUrl("bookmarks"),{method:"POST",body:JSON.stringify(t)});if(!a.ok){const e=await a.json();throw new o(e.detail||e.message||"Bookmark creation failed",e.code,a.status)}const s=await a.json(),r={id:s.data.record_id,bookmark:t,created_at:s.timestamp||(new Date).toISOString(),updated_at:s.timestamp||(new Date).toISOString()};return n.ConfigManager.log("info","Bookmark created successfully",{bookmarkId:r.id,message:s.message}),r}catch(e){if(n.ConfigManager.log("error","Bookmark creation error:",e),e instanceof o)throw e;throw new o("Bookmark creation failed","BOOKMARK_ERROR")}}async getBookmarks(e={}){try{n.ConfigManager.log("info","Fetching bookmarks",{params:e});const t=new URL(n.ConfigManager.getDataApiUrl("bookmarks"));Object.keys(e).forEach(a=>t.searchParams.append(a,e[a]));const a=await this.authManager.makeAuthenticatedRequest(t.toString(),{method:"GET"});if(!a.ok){const e=await a.json();throw new o(e.detail||"Failed to fetch bookmarks",e.code,a.status)}const s=await a.json();return n.ConfigManager.log("info","Bookmarks fetched successfully",{count:s.bookmarks.length,total:s.total}),s}catch(e){if(n.ConfigManager.log("error","Bookmark fetch error:",e),e instanceof o)throw e;throw new o("Failed to fetch bookmarks","BOOKMARK_FETCH_ERROR")}}async getSettings(){try{n.ConfigManager.log("info","Fetching extension settings");const e=await this.authManager.makeAuthenticatedRequest(n.ConfigManager.getDataApiUrl("settings"),{method:"GET"});if(!e.ok){const t=await e.json();throw new o(t.detail||"Failed to fetch settings",t.code,e.status)}const t=await e.json();return n.ConfigManager.log("info","Settings fetched successfully"),t}catch(e){if(n.ConfigManager.log("error","Settings fetch error:",e),e instanceof o)throw e;throw new o("Failed to fetch settings","SETTINGS_FETCH_ERROR")}}async updateSettings(e){try{n.ConfigManager.log("info","Updating extension settings",{keys:Object.keys(e)}),await this.addAuditLogEntry({action:"settings_updated",resource_type:"page",details:{settings_updated:Object.keys(e),privacy_changes:!!e.encrypt_local_data||!!e.share_with_team}});const t={settings:e},a=await this.authManager.makeAuthenticatedRequest(n.ConfigManager.getDataApiUrl("settings"),{method:"POST",body:JSON.stringify(t)});if(!a.ok){const e=await a.json();throw new o(e.detail||"Settings update failed",e.code,a.status)}const s=await a.json();return n.ConfigManager.log("info","Settings updated successfully"),s}catch(e){if(n.ConfigManager.log("error","Settings update error:",e),e instanceof o)throw e;throw new o("Settings update failed","SETTINGS_UPDATE_ERROR")}}async syncData(e){try{n.ConfigManager.log("info","Starting data synchronization",{syncType:e.type||"incremental",forceSync:e.force_sync||!1}),await this.addAuditLogEntry({action:"data_sync_initiated",resource_type:"investigation",details:{sync_type:e.type||"incremental",force_sync:e.force_sync||!1,last_sync:e.last_sync}});const t=await this.authManager.makeAuthenticatedRequest(n.ConfigManager.getDataApiUrl("sync"),{method:"POST",body:JSON.stringify(e)});if(!t.ok){const a=await t.json();throw new r(a.detail||"Data synchronization failed",e.type,0,!0)}const a=await t.json();return await this.addAuditLogEntry({action:"data_sync_completed",resource_type:"investigation",details:{items_synced:a.items_synced,conflicts:a.conflicts.length,status:a.status}}),n.ConfigManager.log("info","Data synchronization completed",{itemsSynced:a.items_synced,conflicts:a.conflicts.length,status:a.status}),a}catch(t){if(n.ConfigManager.log("error","Data sync error:",t),await this.addAuditLogEntry({action:"data_sync_failed",resource_type:"investigation",details:{error:t instanceof Error?t.message:String(t),sync_type:e.type}}),t instanceof r)throw t;throw new r("Data synchronization failed",e.type,0,!0)}}transformURLForBackend(e){try{const{url:t,title:a,description:s,tags:o,metadata:r,dwell_time:i,scroll_count:c,click_count:l,focus_time:g,idle_time:u,exit_type:d,domain:h,is_suspicious:m,page_load_time:f,response_status:p,interaction_heatmap:w,performance_metrics:y}=e;if(!t)return n.ConfigManager.log("warn","URL missing in transformation, skipping:",e),null;const v=r?.engagement_analytics||{},k=r?.performance_metrics||{},M=r?.interaction_heatmap||{},_=i??v.dwell_time??0,b=c??v.scroll_count??0,S=l??v.click_count??0,C=g??v.focus_time??0,E=u??v.idle_time??0,U=d??v.exit_type??null;let R;try{R=h||r?.domain||new URL(t).hostname}catch(e){R=t.split("/")[2]||"unknown",n.ConfigManager.log("warn","Failed to parse domain from URL:",t)}const I={...k,...y,page_load_time:f??k?.page_load_time??void 0,response_status:p??k?.response_status??void 0},A={};Object.entries(I).forEach(([e,t])=>{null!=t&&(A[e]=t)});const T={...M,...w},D={};Object.entries(T).forEach(([e,t])=>{Array.isArray(t)?t.length>0&&(D[e]=t):t&&"object"==typeof t&&"viewport"===e&&"number"==typeof t.width&&"number"==typeof t.height&&(D[e]=t)});const x={url:t,title:a||"Untitled Page",dwell_time:_,scroll_count:b,click_count:S,focus_time:C,idle_time:E,...U?{exit_type:U}:{},is_suspicious:m??r?.is_suspicious??!1,...R?{domain:R}:{}};void 0!==A.page_load_time&&(x.page_load_time=A.page_load_time),void 0!==A.response_status&&(x.response_status=A.response_status),Object.keys(D).length>0&&(x.interaction_heatmap=D),Object.keys(A).length>0&&(x.performance_metrics=A);const F={auto_capture:r?.auto_capture,source:r?.source,extension_version:r?.extension_version,tab_id:r?.tab_id,session_id:r?.session_id,capture_timestamp:r?.capture_timestamp,user_agent:r?.user_agent,referrer:r?.referrer,description:s,tags:o,threat_indicators:r?.threat_indicators,...Object.fromEntries(Object.entries(r||{}).filter(([e])=>!["engagement_analytics","performance_metrics","interaction_heatmap","is_suspicious","auto_capture","source","extension_version","tab_id","session_id","capture_timestamp","user_agent","referrer","threat_indicators"].includes(e)))},L={};return Object.entries(F).forEach(([e,t])=>{null==t||Array.isArray(t)&&0===t.length||(L[e]=t)}),Object.keys(L).length>0&&(x.metadata=L),n.ConfigManager.log("info","URL transformed for backend",{originalURL:t,dwellTime:x.dwell_time,scrollCount:x.scroll_count,clickCount:x.click_count,hasTags:!!x.metadata?.tags?.length,hasDescription:!!x.metadata?.description,hadExistingTopLevelData:!!(i||c||l),hadNestedData:!!(v.dwell_time||v.scroll_count||v.click_count)}),x}catch(t){return n.ConfigManager.log("error","Error transforming URL for backend:",t,e),null}}async submitBulkData(e){try{const t=(e.urls?.length||0)+(e.iocs?.length||0)+(e.screenshots?.length||0)+(e.notes?.length||0);n.ConfigManager.log("info","Starting bulk data submission",{totalItems:t});const a=e.urls?.map(e=>this.transformURLForBackend(e)).filter(e=>null!==e)||[],r={...e,urls:a};n.ConfigManager.log("info","Transformed URL data for backend compatibility",{originalCount:e.urls?.length||0,transformedCount:a.length,skippedCount:(e.urls?.length||0)-a.length});const i=await this.getCurrentUserId(),c=s.workSessionManager.getCurrentInvestigationId();if(!i)throw new o("User not authenticated","AUTHENTICATION_ERROR");if(!c)throw new o("No active investigation found","NO_INVESTIGATION_ERROR");await this.addAuditLogEntry({action:"bulk_data_submitted",resource_type:"investigation",details:{urls_count:e.urls?.length||0,iocs_count:e.iocs?.length||0,screenshots_count:e.screenshots?.length||0,notes_count:e.notes?.length||0,total_items:t,user_id:i,investigation_id:c}});const l=n.ConfigManager.getInvestigationApiUrl("bulkData"),g=`${l}?user_id=${encodeURIComponent(i)}&investigation_id=${encodeURIComponent(c)}`;n.ConfigManager.log("info","Making bulk data request with parameters",{baseUrl:l,userId:i,investigationId:c,fullUrl:g});const u=await this.authManager.makeAuthenticatedRequest(g,{method:"POST",body:JSON.stringify(r)});if(!u.ok){const e=await u.json();throw new o(e.detail||"Bulk data submission failed",e.code,u.status)}const d=await u.json();return n.ConfigManager.log("info","Bulk data submission completed",{urlsCreated:d.urls_created,iocsCreated:d.iocs_created,screenshotsCreated:d.screenshots_created,notesCreated:d.notes_created,errors:d.errors.length,processingTime:d.processing_time}),d}catch(e){if(n.ConfigManager.log("error","Bulk data submission error:",e),e instanceof o)throw e;throw new o("Bulk data submission failed","BULK_SUBMISSION_ERROR")}}async submitURL(e){try{const t=await this.getCurrentUserId(),a=s.workSessionManager.getCurrentInvestigationId();if(!t)throw new o("User not authenticated","AUTHENTICATION_ERROR");if(!a)throw new o("No active investigation found","NO_INVESTIGATION_ERROR");const r=this.transformURLForBackend(e);if(!r)throw new o("Failed to transform URL data","TRANSFORMATION_ERROR");n.ConfigManager.log("info","Submitting individual URL with transformation",{originalURL:e.url,transformedDwellTime:r.dwell_time,transformedScrollCount:r.scroll_count,transformedClickCount:r.click_count});const i=`${n.ConfigManager.getInvestigationApiUrl("urls")}?user_id=${encodeURIComponent(t)}&investigation_id=${encodeURIComponent(a)}`,c=await this.authManager.makeAuthenticatedRequest(i,{method:"POST",body:JSON.stringify([r])});if(!c.ok){const e=await c.json();throw new o(e.detail||"URL submission failed",e.code,c.status)}return await c.json()}catch(e){throw n.ConfigManager.log("error","URL submission error:",e),e instanceof o?e:new o("URL submission failed","URL_SUBMISSION_ERROR")}}async submitIOC(e){try{const t=await this.getCurrentUserId(),a=s.workSessionManager.getCurrentInvestigationId();if(!t)throw new o("User not authenticated","AUTHENTICATION_ERROR");if(!a)throw new o("No active investigation found","NO_INVESTIGATION_ERROR");const r=`${n.ConfigManager.getInvestigationApiUrl("iocs")}?user_id=${encodeURIComponent(t)}&investigation_id=${encodeURIComponent(a)}`,i=await this.authManager.makeAuthenticatedRequest(r,{method:"POST",body:JSON.stringify(e)});if(!i.ok){const e=await i.json();throw new o(e.detail||"IOC submission failed",e.code,i.status)}return await i.json()}catch(e){throw n.ConfigManager.log("error","IOC submission error:",e),e instanceof o?e:new o("IOC submission failed","IOC_SUBMISSION_ERROR")}}async submitScreenshot(e){try{const t=await this.getCurrentUserId(),a=s.workSessionManager.getCurrentInvestigationId();if(!t)throw new o("User not authenticated","AUTHENTICATION_ERROR");if(!a)throw new o("No active investigation found","NO_INVESTIGATION_ERROR");const r={url:e.url,data_url:e.metadata?.data_url,file_size:e.metadata?.file_size,width:e.metadata?.width,height:e.metadata?.height,screenshot_type:e.metadata?.screenshot_type||"visible_area",metadata:{filename:e.filename,description:e.description,tags:e.tags,page_title:e.metadata?.page_title,captured_at:e.metadata?.captured_at,link_count:e.metadata?.link_count,image_count:e.metadata?.image_count}},i=`${n.ConfigManager.getInvestigationApiUrl("screenshots")}?user_id=${encodeURIComponent(t)}&investigation_id=${encodeURIComponent(a)}`;n.ConfigManager.log("info","Submitting screenshot",{url:e.url,hasDataUrl:!!r.data_url,fileSize:r.file_size,dimensions:`${r.width}x${r.height}`});const c=await this.authManager.makeAuthenticatedRequest(i,{method:"POST",body:JSON.stringify(r)});if(!c.ok){const e=await c.json();throw new o(e.detail||"Screenshot submission failed",e.code,c.status)}const l=await c.json();return n.ConfigManager.log("info","Screenshot submitted successfully",{id:l.id}),l}catch(e){throw n.ConfigManager.log("error","Screenshot submission error:",e),e instanceof o?e:new o("Screenshot submission failed","SCREENSHOT_SUBMISSION_ERROR")}}async submitNote(e){try{const t=await this.getCurrentUserId(),a=s.workSessionManager.getCurrentInvestigationId();if(!t)throw new o("User not authenticated","AUTHENTICATION_ERROR");if(!a)throw new o("No active investigation found","NO_INVESTIGATION_ERROR");const r=`${n.ConfigManager.getInvestigationApiUrl("notes")}?user_id=${encodeURIComponent(t)}&investigation_id=${encodeURIComponent(a)}`,i=await this.authManager.makeAuthenticatedRequest(r,{method:"POST",body:JSON.stringify(e)});if(!i.ok){const e=await i.json();throw new o(e.detail||"Note submission failed",e.code,i.status)}return await i.json()}catch(e){throw n.ConfigManager.log("error","Note submission error:",e),e instanceof o?e:new o("Note submission failed","NOTE_SUBMISSION_ERROR")}}async getCurrentUserId(){try{const e=await this.authManager.getCurrentUser();return e?.id||"unknown"}catch(e){return n.ConfigManager.log("warn","Could not determine current user ID:",e),"unknown"}}async addAuditLogEntry(e){try{const t={...e,timestamp:Date.now(),user_id:await this.getCurrentUserId(),ip_address:"extension",user_agent:navigator.userAgent};this.auditLog.push(t),this.auditLog.length>1e3&&(this.auditLog=this.auditLog.slice(-1e3)),n.ConfigManager.log("info","Audit log entry added",{action:e.action,resource_type:e.resource_type})}catch(e){n.ConfigManager.log("warn","Failed to add audit log entry:",e)}}getAuditLog(){return[...this.auditLog]}clearAuditLog(){this.auditLog=[],n.ConfigManager.log("info","Audit log cleared")}}let c;async function l(e){try{n.ConfigManager.log("info","Initializing data manager feature"),c=new i(e),n.ConfigManager.log("info","Data manager feature initialized successfully")}catch(e){throw n.ConfigManager.log("error","Error initializing data manager feature:",e),e}}},943:(e,t,a)=>{a.d(t,{I:()=>r,workSessionManager:()=>o});var s=a(240);class n{constructor(e){this.currentSession=null,this.heartbeatInterval=null,this.HEARTBEAT_INTERVAL=3e4,this.authManager=e,this.setupVisibilityListeners()}async startWorkSession(e){try{s.ConfigManager.log("info","Starting work session",{investigationId:e});const t=await this.getCurrentUserId();if(!t)throw new Error("User not authenticated");const a=await this.getScreenResolution(),n={browser:"Chrome Extension",extension_version:chrome.runtime.getManifest().version,timezone:Intl.DateTimeFormat().resolvedOptions().timeZone,screen_resolution:a},o=await this.authManager.makeAuthenticatedRequest(`${s.ConfigManager.getApiUrl("auth.status").replace("/api/v1/chrome/auth/status","")}/api/v1/chrome/investigations/${e}/start-session?user_id=${t}`,{method:"POST",body:JSON.stringify({session_metadata:n})});if(!o.ok){const e=await o.json();throw new Error(e.detail||"Failed to start work session")}const r=await o.json();this.currentSession={session_id:r.data.session_id,investigation_id:e,investigation_name:"",case_number:"",started_at:r.data.started_at,last_activity:(new Date).toISOString(),duration_minutes:0},this.startHeartbeat(),chrome.runtime.sendMessage({type:"SESSION_STARTED",investigationId:e,sessionId:this.currentSession.session_id});try{const e=chrome.runtime.getURL("url-import.html");await chrome.windows.create({url:e,type:"popup",width:640,height:720,focused:!0})}catch(e){s.ConfigManager.log("warn","Failed to open URL import window:",e)}return s.ConfigManager.log("info","Work session started successfully",{sessionId:this.currentSession.session_id,investigationId:e}),this.currentSession}catch(e){throw s.ConfigManager.log("error","Failed to start work session:",e),e}}async getCurrentSession(){try{const e=await this.getCurrentUserId();if(!e)return null;const t=await this.authManager.makeAuthenticatedRequest(`${s.ConfigManager.getApiUrl("auth.status").replace("/api/v1/chrome/auth/status","")}/api/v1/chrome/investigations/my-session?user_id=${e}`,{method:"GET"});if(!t.ok){if(404===t.status)return this.currentSession=null,this.stopHeartbeat(),null;throw new Error("Failed to get current session")}const a=await t.json();return a.success&&a.data?.session?(this.currentSession=a.data.session,this.heartbeatInterval||this.startHeartbeat(),this.currentSession):(this.currentSession=null,this.stopHeartbeat(),null)}catch(e){return s.ConfigManager.log("error","Failed to get current session:",e),null}}async endWorkSession(){try{if(!this.currentSession)return void s.ConfigManager.log("warn","No active session to end");const e=await this.getCurrentUserId();if(!e)throw new Error("User not authenticated");this.stopHeartbeat();const t=await this.authManager.makeAuthenticatedRequest(`${s.ConfigManager.getApiUrl("auth.status").replace("/api/v1/chrome/auth/status","")}/api/v1/chrome/investigations/end-session?user_id=${e}`,{method:"POST"});if(!t.ok){const e=await t.json();s.ConfigManager.log("warn","Failed to end session via API:",e)}const a=this.currentSession.session_id;this.currentSession=null,chrome.runtime.sendMessage({type:"SESSION_ENDED",sessionId:a}),s.ConfigManager.log("info","Work session ended",{sessionId:a})}catch(e){s.ConfigManager.log("error","Error ending work session:",e),this.currentSession=null,this.stopHeartbeat()}}getCurrentInvestigationId(){return this.currentSession?.investigation_id||null}hasActiveSession(){return null!==this.currentSession}startHeartbeat(){this.stopHeartbeat(),this.sendHeartbeat(),this.heartbeatInterval=setInterval(()=>{this.sendHeartbeat()},this.HEARTBEAT_INTERVAL),s.ConfigManager.log("info","Heartbeat started")}stopHeartbeat(){this.heartbeatInterval&&(clearInterval(this.heartbeatInterval),this.heartbeatInterval=null,s.ConfigManager.log("info","Heartbeat stopped"))}async sendHeartbeat(){try{if(!this.currentSession)return void this.stopHeartbeat();const e=await this.getCurrentUserId();if(!e)return void this.stopHeartbeat();const t=await this.getCurrentPageInfo(),a=await this.authManager.makeAuthenticatedRequest(`${s.ConfigManager.getApiUrl("auth.status").replace("/api/v1/chrome/auth/status","")}/api/v1/chrome/investigations/heartbeat?user_id=${e}&current_page=${encodeURIComponent(t)}`,{method:"POST"});a.ok?this.currentSession&&(this.currentSession.last_activity=(new Date).toISOString()):(s.ConfigManager.log("warn","Heartbeat failed:",a.status),401!==a.status&&403!==a.status||(this.currentSession=null,this.stopHeartbeat()))}catch(e){s.ConfigManager.log("error","Heartbeat error:",e)}}async getInvestigationCollaborators(e){try{const t=await this.authManager.makeAuthenticatedRequest(`${s.ConfigManager.getApiUrl("auth.status").replace("/api/v1/chrome/auth/status","")}/api/v1/chrome/investigations/${e}/collaborators`,{method:"GET"});if(!t.ok)throw new Error("Failed to get collaborators");return(await t.json()).data}catch(e){throw s.ConfigManager.log("error","Failed to get collaborators:",e),e}}async getAllActiveSessions(){try{const e=await this.authManager.makeAuthenticatedRequest(`${s.ConfigManager.getApiUrl("auth.status").replace("/api/v1/chrome/auth/status","")}/api/v1/chrome/investigations/active-sessions`,{method:"GET"});if(!e.ok)throw new Error("Failed to get active sessions");return(await e.json()).data}catch(e){throw s.ConfigManager.log("error","Failed to get all active sessions:",e),e}}async getCurrentUserId(){try{const e=await this.authManager.getCurrentUser();return e?.id||null}catch(e){return s.ConfigManager.log("error","Failed to get current user ID:",e),null}}async getCurrentPageInfo(){try{const[e]=await chrome.tabs.query({active:!0,currentWindow:!0});return e?.url?e.url:"extension"}catch(e){return"extension"}}async getScreenResolution(){try{const[e]=await chrome.tabs.query({active:!0,currentWindow:!0});if(e?.id)try{const t=await chrome.tabs.sendMessage(e.id,{type:"GET_SCREEN_RESOLUTION"});if(t?.success&&t?.data?.resolution)return t.data.resolution}catch(e){s.ConfigManager.log("warn","Could not get screen resolution from content script:",e)}return"1920x1080"}catch(e){return s.ConfigManager.log("warn","Error getting screen resolution:",e),"1920x1080"}}setupVisibilityListeners(){chrome.windows.onFocusChanged.addListener(e=>{e!==chrome.windows.WINDOW_ID_NONE&&this.currentSession&&this.sendHeartbeat()}),chrome.runtime.onSuspend.addListener(()=>{this.endWorkSession()})}}let o;async function r(e){console.log("[WorkSession] Initializing work session feature");try{o=new n(e),await o.getCurrentSession(),console.log("[WorkSession] Work session feature initialized successfully")}catch(e){throw console.error("[WorkSession] Error initializing work session feature:",e),e}}}},t={};function a(s){var n=t[s];if(void 0!==n)return n.exports;var o=t[s]={exports:{}};return e[s](o,o.exports,a),o.exports}a.d=(e,t)=>{for(var s in t)a.o(t,s)&&!a.o(e,s)&&Object.defineProperty(e,s,{enumerable:!0,get:t[s]})},a.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),a.d({},{M:()=>U});var s=a(892),n=a(240),o=a(366);const r=new class{constructor(){this.extensionId=n.$.extension.id||"unknown"}async register(e,t,a,s){try{n.ConfigManager.log("info","Starting user registration",{email:e});const r={email:e,password:t,confirm_password:t,extension_id:this.extensionId,first_name:a,last_name:s},i=await this.makeRequest(n.ConfigManager.getApiUrl("auth.register"),{method:"POST",body:JSON.stringify(r)});if(!i.ok){const e=await i.json();throw new o.lR(e.detail||"Registration failed",e.code,i.status)}const c=await i.json();return await this.storeAuthData(c),n.ConfigManager.log("info","Registration successful",{userId:c.user.id,email:c.user.email}),c}catch(e){if(n.ConfigManager.log("error","Registration error:",e),e instanceof o.lR)throw e;throw new o.lR("Registration failed","REGISTRATION_ERROR")}}async login(e,t){try{n.ConfigManager.log("info","Starting user login",{email:e});const a={email:e,password:t,extension_id:this.extensionId,remember_me:!0},s=await this.makeRequest(n.ConfigManager.getApiUrl("auth.login"),{method:"POST",body:JSON.stringify(a)});if(!s.ok){const e=await s.json();throw new o.lR(e.detail||"Login failed",e.code,s.status)}const r=await s.json();await this.storeAuthData(r);try{const e=await this.getMFAStatus();e.has_mfa_enabled&&"aal2"!==e.current_aal&&(n.ConfigManager.log("info","MFA enrolled but not verified; prompt for verification"),await chrome.storage.local.set({aal_level:e.current_aal}))}catch(e){n.ConfigManager.log("warn","Unable to fetch MFA status after login; proceeding without MFA enforcement",e)}return n.ConfigManager.log("info","Login successful",{userId:r.user.id,email:r.user.email}),r}catch(e){if(n.ConfigManager.log("error","Login error:",e),e instanceof o.lR)throw e;throw new o.lR("Login failed","LOGIN_ERROR")}}async getValidToken(){try{const e=await chrome.storage.local.get([n.$.storage.keys.accessToken,n.$.storage.keys.refreshToken,n.$.storage.keys.expiresAt]),t=e[n.$.storage.keys.accessToken],a=e[n.$.storage.keys.expiresAt];if(!t||!a)return n.ConfigManager.log("info","No valid token found"),null;const s=60*n.$.security.tokenRefreshThreshold*1e3;if(a-Date.now()<s){n.ConfigManager.log("info","Token expires soon, refreshing...");try{return await this.refreshToken()}catch(e){return n.ConfigManager.log("error","Token refresh failed:",e),null}}return t}catch(e){return n.ConfigManager.log("error","Error getting valid token:",e),null}}async refreshToken(){try{const e=(await chrome.storage.local.get([n.$.storage.keys.refreshToken]))[n.$.storage.keys.refreshToken];if(!e)throw new o.BX;const t={refresh_token:e,extension_id:this.extensionId},a=await this.makeRequest(n.ConfigManager.getApiUrl("auth.refresh"),{method:"POST",body:JSON.stringify(t)});if(!a.ok){if(401===a.status)throw await chrome.storage.local.clear(),new o.BX;throw new o.lR("Token refresh failed","REFRESH_ERROR",a.status)}const s=await a.json();if(!s.session_id&&s.access_token)try{const e=JSON.parse(atob(s.access_token.split(".")[1]));e.session_id&&(s.session_id=e.session_id)}catch{}return await this.storeAuthData(s),n.ConfigManager.log("info","Token refreshed successfully"),s.access_token}catch(e){if(n.ConfigManager.log("error","Token refresh error:",e),e instanceof o.BX||e instanceof o.lR)throw e;throw new o.lR("Token refresh failed","REFRESH_ERROR")}}async verifySession(){try{const e=(await chrome.storage.local.get([n.$.storage.keys.sessionId]))[n.$.storage.keys.sessionId];if(!e)return!1;const t={session_id:e,extension_id:this.extensionId},a=(await this.makeRequest(n.ConfigManager.getApiUrl("auth.verify"),{method:"POST",body:JSON.stringify(t)})).ok;return n.ConfigManager.log("info","Session verification result:",{isValid:a}),a}catch(e){return n.ConfigManager.log("error","Session verification failed:",e),!1}}async logout(e=!1){try{const t=(await chrome.storage.local.get([n.$.storage.keys.sessionId]))[n.$.storage.keys.sessionId];if(t){const a={session_id:t,extension_id:this.extensionId,logout_all:e};try{await this.makeRequest(n.ConfigManager.getApiUrl("auth.logout"),{method:"POST",body:JSON.stringify(a)}),n.ConfigManager.log("info","Logout request successful")}catch(e){n.ConfigManager.log("warn","Logout request failed, clearing local data anyway:",e)}}await chrome.storage.local.clear(),n.ConfigManager.log("info","Local authentication data cleared")}catch(e){n.ConfigManager.log("error","Logout error:",e);try{await chrome.storage.local.clear()}catch(e){n.ConfigManager.log("error","Failed to clear local storage:",e)}}}async storeAuthData(e){try{const t=Date.now()+1e3*e.expires_in;let a=e.session_id;if(e.access_token)try{const t=JSON.parse(atob(e.access_token.split(".")[1]));console.log("🔍 [AUTH-DEBUG] JWT session_id:",t.session_id),console.log("🔍 [AUTH-DEBUG] Response session_id:",e.session_id),console.log("🔍 [AUTH-DEBUG] JWT aal:",t.aal),t.session_id&&(a=t.session_id,console.log("🔧 [AUTH-DEBUG] Using JWT session_id instead of response session_id"))}catch(e){console.log("🔍 [AUTH-DEBUG] Could not decode JWT:",e)}await chrome.storage.local.set({[n.$.storage.keys.accessToken]:e.access_token,[n.$.storage.keys.refreshToken]:e.refresh_token,[n.$.storage.keys.sessionId]:a,[n.$.storage.keys.user]:e.user,[n.$.storage.keys.expiresAt]:t}),n.ConfigManager.log("info","Authentication data stored successfully"),console.log("🔍 [AUTH-DEBUG] Stored session_id:",a)}catch(e){throw n.ConfigManager.log("error","Failed to store auth data:",e),new o.lR("Failed to store authentication data","STORAGE_ERROR")}}async isAuthenticated(){try{return!!await this.getValidToken()}catch(e){return n.ConfigManager.log("error","Authentication check failed:",e),!1}}async getCurrentUser(){try{return(await chrome.storage.local.get([n.$.storage.keys.user]))[n.$.storage.keys.user]||null}catch(e){return n.ConfigManager.log("error","Failed to get current user:",e),null}}async makeAuthenticatedRequest(e,t={}){const{includeAuth:a=!0,retries:s=n.$.security.maxRetries,...r}=t;if(console.log("🔐 [AUTH-DEBUG] Making authenticated request to:",e),console.log("🔐 [AUTH-DEBUG] Include auth:",a),a){const e=await this.getValidToken();if(!e)throw console.log("⚠️ [AUTH-DEBUG] No valid token available"),new o.BX;const t=(await chrome.storage.local.get([n.$.storage.keys.sessionId]))[n.$.storage.keys.sessionId];if(console.log("🔑 [AUTH-DEBUG] Token preview for request:",e.substring(0,20)+"..."),console.log("🔑 [AUTH-DEBUG] Session ID for request:",t),r.headers={...n.ConfigManager.getHeaders(),Authorization:`Bearer ${e}`,"X-Session-ID":t,...r.headers},console.log("📋 [AUTH-DEBUG] Request headers being sent:"),console.log("📋 [AUTH-DEBUG] - Authorization:",`Bearer ${e.substring(0,20)}...`),console.log("📋 [AUTH-DEBUG] - X-Session-ID:",t),r.headers){const e=r.headers;console.log("📋 [AUTH-DEBUG] - X-Extension-ID:",e["X-Extension-ID"]),console.log("📋 [AUTH-DEBUG] - Content-Type:",e["Content-Type"]),console.log("📋 [AUTH-DEBUG] - All headers:",e)}}let i=null;for(let t=0;t<=s;t++)try{const n=await this.makeRequest(e,r);if(401===n.status&&a&&t<s)try{await this.refreshToken();const e=await this.getValidToken();if(e){r.headers={...r.headers,Authorization:`Bearer ${e}`};continue}}catch(e){throw new o.BX}return n}catch(e){if(i=e,t===s)break;await new Promise(e=>setTimeout(e,1e3*(t+1)))}throw i||new o.Dr("Request failed after retries")}async getMFAStatus(){console.log("🔍 [MFA-DEBUG] Getting MFA status...");const e=await this.getValidToken();if(console.log("🔑 [MFA-DEBUG] Token available:",!!e),e){console.log("🔑 [MFA-DEBUG] Token preview:",e.substring(0,20)+"...");try{const t=JSON.parse(atob(e.split(".")[1]));console.log("🔍 [MFA-DEBUG] JWT session_id:",t.session_id),console.log("🔍 [MFA-DEBUG] JWT aal:",t.aal);const a=(await chrome.storage.local.get([n.$.storage.keys.sessionId]))[n.$.storage.keys.sessionId];console.log("🔍 [MFA-DEBUG] Stored session_id:",a),console.log("🔍 [MFA-DEBUG] Session mismatch:",t.session_id!==a)}catch(e){console.error("🔍 [MFA-DEBUG] Error parsing JWT:",e)}}const t=n.ConfigManager.getApiUrl("auth.mfa.status");console.log("📡 [MFA-DEBUG] Making request to:",t);const a=await this.makeAuthenticatedRequest(t,{method:"POST"});if(console.log("📡 [MFA-DEBUG] MFA Status Response status:",a.status),console.log("📡 [MFA-DEBUG] MFA Status Response headers:",a.headers),!a.ok){const e=await a.text();throw console.error("❌ [MFA-DEBUG] MFA Status Error response:",e),new o.lR("Failed to get MFA status","MFA_STATUS_ERROR",a.status)}const s=await a.json();return console.log("✅ [MFA-DEBUG] MFA Status data:",s),console.log("✅ [MFA-DEBUG] MFA Status detailed:"),console.log("   - has_mfa_enabled:",s.has_mfa_enabled),console.log("   - current_aal:",s.current_aal),console.log("   - full response:",JSON.stringify(s,null,2)),s}async enrollMFA(e="totp",t){console.log("🔍 [MFA-DEBUG] Enrolling MFA..."),console.log("🔍 [MFA-DEBUG] Factor type:",e,"Friendly name:",t);const a=await this.getValidToken();console.log("🔑 [MFA-DEBUG] Token available for enrollment:",!!a);const s={factor_type:e,friendly_name:t};console.log("📡 [MFA-DEBUG] Enrollment request body:",s);const r=n.ConfigManager.getApiUrl("auth.mfa.enroll");console.log("📡 [MFA-DEBUG] Making enrollment request to:",r);const i=await this.makeAuthenticatedRequest(r,{method:"POST",body:JSON.stringify(s)});if(console.log("📡 [MFA-DEBUG] Enrollment Response status:",i.status),!i.ok){const e=await i.text();throw console.error("❌ [MFA-DEBUG] Enrollment Error response:",e),new o.lR("MFA enrollment failed","MFA_ENROLL_ERROR",i.status)}const c=await i.json();return console.log("✅ [MFA-DEBUG] Enrollment data received"),c}async createChallenge(e){console.log("🔍 [MFA-DEBUG] Creating challenge for factor:",e);const t=await this.getValidToken();console.log("🔑 [MFA-DEBUG] Token available for challenge:",!!t);const a={factor_id:e},s=n.ConfigManager.getApiUrl("auth.mfa.challenge");console.log("📡 [MFA-DEBUG] Making challenge request to:",s);const r=await this.makeAuthenticatedRequest(s,{method:"POST",body:JSON.stringify(a)});if(console.log("📡 [MFA-DEBUG] Challenge Response status:",r.status),!r.ok){const e=await r.text();throw console.error("❌ [MFA-DEBUG] Challenge Error response:",e),new o.lR("MFA challenge failed","MFA_CHALLENGE_ERROR",r.status)}const i=await r.json();return console.log("✅ [MFA-DEBUG] Challenge data received"),i}async verifyMFA(e,t,a){console.log("🔍 [MFA-DEBUG] Verifying MFA..."),console.log("🔍 [MFA-DEBUG] Factor:",e,"Challenge:",t,"Code length:",a.length);const s=await this.getValidToken();console.log("🔑 [MFA-DEBUG] Token available for verification:",!!s);const r={factor_id:e,challenge_id:t,code:a},i=n.ConfigManager.getApiUrl("auth.mfa.verify");console.log("📡 [MFA-DEBUG] Making verification request to:",i);const c=await this.makeAuthenticatedRequest(i,{method:"POST",body:JSON.stringify(r)});if(console.log("📡 [MFA-DEBUG] Verification Response status:",c.status),!c.ok){const e=await c.text();throw console.error("❌ [MFA-DEBUG] Verification Error response:",e),new o.lR("MFA verification failed","MFA_VERIFY_ERROR",c.status)}const l=await c.json();return console.log("✅ [MFA-DEBUG] Verification successful, data:",l),{success:!0,...l}}async listFactors(){console.log("🔍 [MFA-DEBUG] Listing MFA factors...");const e=await this.getValidToken();console.log("🔑 [MFA-DEBUG] Token available for listing factors:",!!e);const t=n.ConfigManager.getApiUrl("auth.mfa.factors");console.log("📡 [MFA-DEBUG] Making factors request to:",t);const a=await this.makeAuthenticatedRequest(t,{method:"GET"});if(console.log("📡 [MFA-DEBUG] Factors Response status:",a.status),!a.ok){const e=await a.text();throw console.error("❌ [MFA-DEBUG] Factors Error response:",e),new o.lR("Failed to list MFA factors","MFA_LIST_ERROR",a.status)}const s=await a.json();console.log("✅ [MFA-DEBUG] Factors data:",s),console.log("✅ [MFA-DEBUG] Factors detailed:"),console.log("   - totp_factors count:",s.totp_factors?s.totp_factors.length:0),console.log("   - phone_factors count:",s.phone_factors?s.phone_factors.length:0),console.log("   - total_factors:",s.total_factors),console.log("   - full response:",JSON.stringify(s,null,2));const r=[...s.totp_factors||[],...s.phone_factors||[]];return console.log("✅ [MFA-DEBUG] Returning combined factors:",r.length),r}async unenrollMFA(e){console.log("🔍 [MFA-DEBUG] Unenrolling MFA factor:",e);const t=await this.getValidToken();console.log("🔑 [MFA-DEBUG] Token available for unenrollment:",!!t);const a={factor_id:e},s=n.ConfigManager.getApiUrl("auth.mfa.unenroll");console.log("📡 [MFA-DEBUG] Making unenroll request to:",s);const r=await this.makeAuthenticatedRequest(s,{method:"POST",body:JSON.stringify(a)});if(console.log("📡 [MFA-DEBUG] Unenroll Response status:",r.status),!r.ok){const e=await r.text();throw console.error("❌ [MFA-DEBUG] Unenroll Error response:",e),new o.lR("MFA unenroll failed","MFA_UNENROLL_ERROR",r.status)}console.log("✅ [MFA-DEBUG] Unenrollment successful")}async makeRequest(e,t={}){const a=new AbortController,s=setTimeout(()=>a.abort(),n.$.security.timeout);try{const s={...t,headers:{...n.ConfigManager.getHeaders(),...t.headers},signal:a.signal};console.log(`[Larvitar-DEBUG] Making request to: ${e}`),console.log(`[Larvitar-DEBUG] Request method: ${s.method||"GET"}`),console.log("[Larvitar-DEBUG] Request headers:",s.headers),console.log("[Larvitar-DEBUG] Request body:",s.body),console.log("[Larvitar-DEBUG] Current environment:",n.ConfigManager.getEnvironmentName());const r=await fetch(e,s);if(console.log(`[Larvitar-DEBUG] Response status: ${r.status}`),console.log("[Larvitar-DEBUG] Response headers:",Object.fromEntries(r.headers.entries())),!r.ok&&r.status>=500)throw new o.Dr(`Server error: ${r.status} ${r.statusText}`,r.status);return r}catch(e){if(console.error("[Larvitar-DEBUG] Request failed:",e),console.error("[Larvitar-DEBUG] Error details:",{name:e instanceof Error?e.name:"Unknown",message:e instanceof Error?e.message:String(e),stack:e instanceof Error?e.stack:void 0}),e instanceof DOMException&&"AbortError"===e.name)throw new o.Dr("Request timeout",408);throw e}finally{clearTimeout(s)}}};var i=a(908),c=a(943);class l{constructor(e,t){this.trackedURLs=new Map,this.submissionQueue=[],this.submissionInterval=3e4,this.maxDwellTime=3e5,this.idleThreshold=12e4,this.dataManager=e,this.workSessionManager=t,this.startPeriodicSubmission(),this.startPeriodicCleanup()}registerURL(e,t,a){console.log("[URLRegistry] 📝 Registering URL for tracking:",{tabId:e,url:t,title:a}),this.trackedURLs.has(e)&&(console.log("[URLRegistry] 🔄 Tab already tracked - finalizing previous URL before registering new one",{tabId:e}),this.unregisterURL(e,"navigation"));const s=Date.now(),o={tabId:e,url:t,title:a,startTime:s,lastUpdate:s,hasEngagementData:!1,readyForSubmission:!1};this.trackedURLs.set(e,o),n.ConfigManager.log("info","URL registered for tracking",{tabId:e,url:t,totalTracked:this.trackedURLs.size})}updateEngagement(e,t){const a=this.trackedURLs.get(e);a?(console.log("[URLRegistry] 📊 Updating engagement data for tab:",e,{clicks:t.engagementData?.click_count,scrolls:t.engagementData?.scroll_count}),a.engagementData={click_count:t.engagementData?.click_count||0,scroll_count:t.engagementData?.scroll_count||0,focus_time:t.engagementData?.focus_time||0,idle_time:t.engagementData?.idle_time||0},a.hasEngagementData=!0,a.lastUpdate=Date.now(),this.checkReadyForSubmission(a)):console.warn("[URLRegistry] ⚠️ Received engagement data for unregistered tab:",e)}unregisterURL(e,t="unknown"){const a=this.trackedURLs.get(e);a&&(console.log("[URLRegistry] 🗑️ Unregistering URL:",{tabId:e,reason:t,url:a.url}),a.hasEngagementData&&(a.readyForSubmission=!0,this.addToSubmissionQueue(a)),this.trackedURLs.delete(e))}checkReadyForSubmission(e){const t=Date.now(),a=t-e.startTime,s=t-e.lastUpdate,n=(e.engagementData?.click_count||0)>3||(e.engagementData?.scroll_count||0)>5||(e.engagementData?.focus_time||0)>2e4;(n||s>this.idleThreshold||a>this.maxDwellTime)&&(e.readyForSubmission||(console.log("[URLRegistry] ✅ URL ready for submission:",{tabId:e.tabId,url:e.url,reason:n?"good_engagement":s>this.idleThreshold?"idle_timeout":"max_dwell_time",clicks:e.engagementData?.click_count,scrolls:e.engagementData?.scroll_count}),e.readyForSubmission=!0,this.addToSubmissionQueue(e)))}addToSubmissionQueue(e){this.submissionQueue.find(t=>t.tabId===e.tabId&&t.url===e.url)||(this.submissionQueue.push({...e}),console.log("[URLRegistry] 📋 Added to submission queue:",{url:e.url,queueSize:this.submissionQueue.length}))}async submitPendingURLs(){if(0===this.submissionQueue.length)return;const e=this.workSessionManager.getCurrentInvestigationId();if(!e)return void console.warn("[URLRegistry] ⚠️ No active investigation - skipping URL submission");const t=this.submissionQueue.splice(0,25);try{console.log("[URLRegistry] 📤 Submitting URLs to backend:",{count:t.length,investigationId:e});const a=t.map(t=>{const a=Date.now()-t.startTime;return{url:t.url,title:t.title,dwell_time:a,scroll_count:t.engagementData?.scroll_count||0,click_count:t.engagementData?.click_count||0,focus_time:t.engagementData?.focus_time||0,idle_time:t.engagementData?.idle_time||0,exit_type:"content_script_submission",is_suspicious:!1,metadata:{auto_capture:!0,source:"content_script_tracking",tab_id:t.tabId,session_id:e,capture_timestamp:(new Date).toISOString()}}});await this.dataManager.submitBulkData({urls:a}),console.log("[URLRegistry] ✅ URLs submitted successfully:",{submitted:a.length,clickCounts:a.map(e=>e.click_count)})}catch(e){console.error("[URLRegistry] ❌ Failed to submit URLs:",e),this.submissionQueue.unshift(...t)}}startPeriodicSubmission(){this.submissionIntervalId=setInterval(()=>{this.submitPendingURLs()},this.submissionInterval)}startPeriodicCleanup(){this.cleanupIntervalId=setInterval(()=>{this.cleanupStaleURLs()},6e4)}cleanupStaleURLs(){const e=Date.now();let t=0;for(const[a,s]of this.trackedURLs.entries()){const n=e-s.lastUpdate;this.checkReadyForSubmission(s),n>6e5&&(this.unregisterURL(a,"stale_cleanup"),t++)}t>0&&console.log("[URLRegistry] 🧹 Cleaned up stale URLs:",t)}getTrackingStatus(){const e=this.workSessionManager.getCurrentInvestigationId();return{isEnabled:!!e,pendingURLs:this.trackedURLs.size,queuedURLs:this.submissionQueue.length,activeInvestigation:e,approach:"content_script",details:{trackedURLs:Array.from(this.trackedURLs.values()).map(e=>({tabId:e.tabId,url:e.url,clicks:e.engagementData?.click_count||0,scrolls:e.engagementData?.scroll_count||0,hasData:e.hasEngagementData,readyForSubmission:e.readyForSubmission}))}}}async forceSubmission(){console.log("[URLRegistry] 🚀 Force submission requested"),await this.submitPendingURLs()}async finalizeAndSubmitAll(){try{console.log("[URLRegistry] 🚀 Finalize and submit ALL tracked URLs (session end)");for(const[e]of this.trackedURLs.entries())this.unregisterURL(e,"session_end");await this.submitPendingURLs(),console.log("[URLRegistry] ✅ Finalize and submit completed")}catch(e){console.error("[URLRegistry] ❌ Finalize and submit failed:",e)}}destroy(){this.submissionIntervalId&&clearInterval(this.submissionIntervalId),this.cleanupIntervalId&&clearInterval(this.cleanupIntervalId)}}let g;class u{async getCacheStats(){try{const e=await chrome.storage.local.get(null),t=await chrome.storage.sync.get(null),a=this.calculateStorageSize(e),s=this.calculateStorageSize(t),o=(await this.getCacheIndex()).items||[],r=o.filter(e=>!e.synced),i=(o.reduce((e,t)=>(e[t.type]=(e[t.type]||0)+1,e),{}),o.filter(e=>e.retry_count>0).length),c=o.length>0?Math.min(...o.map(e=>e.timestamp)):Date.now(),l={total_items:o.length,unsynced_items:r.length,storage_used:a+s,cache_size_mb:(a+s)/1048576,oldest_item:c,sync_errors:i};return n.ConfigManager.log("info","Cache stats retrieved:",l),l}catch(e){throw n.ConfigManager.log("error","Error getting cache stats:",e),e}}async clearCache(e){try{const t=(await this.getCacheIndex()).items||[];let a=[];a=e?.clearAll?t:e?.investigationId?t.filter(t=>t.investigation_id===e.investigationId):e?.type?t.filter(t=>t.type===e.type):t.filter(e=>e.synced);const s=a.map(e=>this.getCacheKey(e.id));s.length>0&&await chrome.storage.local.remove(s);const o=t.filter(e=>!a.some(t=>t.id===e.id));await this.updateCacheIndex(o);const r=e?.clearAll?"All cached data cleared":e?.investigationId?`Cleared ${a.length} items for investigation ${e.investigationId}`:e?.type?`Cleared ${a.length} ${e.type} items`:`Cleared ${a.length} synced items`;return n.ConfigManager.log("info",r),{success:!0,itemsCleared:a.length,message:r}}catch(e){throw n.ConfigManager.log("error","Error clearing cache:",e),e}}async addToCache(e){try{const t=this.getCacheKey(e.id);await chrome.storage.local.set({[t]:e});const a=(await this.getCacheIndex()).items||[],s=a.findIndex(t=>t.id===e.id);s>=0?a[s]=e:a.push(e),await this.updateCacheIndex(a),n.ConfigManager.log("info",`Added item to cache: ${e.type} (${e.id})`)}catch(e){throw n.ConfigManager.log("error","Error adding to cache:",e),e}}async removeFromCache(e){try{const t=this.getCacheKey(e);await chrome.storage.local.remove(t);const a=((await this.getCacheIndex()).items||[]).filter(t=>t.id!==e);await this.updateCacheIndex(a),n.ConfigManager.log("info",`Removed item from cache: ${e}`)}catch(e){throw n.ConfigManager.log("error","Error removing from cache:",e),e}}async getFromCache(e){try{const t=this.getCacheKey(e);return(await chrome.storage.local.get(t))[t]||null}catch(e){return n.ConfigManager.log("error","Error getting from cache:",e),null}}async markAsSynced(e){try{const t=await this.getFromCache(e);t&&(t.synced=!0,t.retry_count=0,await this.addToCache(t))}catch(e){throw n.ConfigManager.log("error","Error marking as synced:",e),e}}async getUnsyncedItems(){try{return((await this.getCacheIndex()).items||[]).filter(e=>!e.synced)}catch(e){return n.ConfigManager.log("error","Error getting unsynced items:",e),[]}}async getCacheIndex(){try{return(await chrome.storage.local.get(u.CACHE_INDEX_KEY))[u.CACHE_INDEX_KEY]||{items:[],lastUpdated:Date.now()}}catch(e){return n.ConfigManager.log("error","Error getting cache index:",e),{items:[],lastUpdated:Date.now()}}}async updateCacheIndex(e){try{await chrome.storage.local.set({[u.CACHE_INDEX_KEY]:{items:e,lastUpdated:Date.now()}})}catch(e){throw n.ConfigManager.log("error","Error updating cache index:",e),e}}getCacheKey(e){return`${u.CACHE_PREFIX}${e}`}calculateStorageSize(e){try{const t=JSON.stringify(e);return new Blob([t]).size}catch(e){return n.ConfigManager.log("warn","Error calculating storage size:",e),0}}async getInvestigationCache(e){try{return((await this.getCacheIndex()).items||[]).filter(t=>t.investigation_id===e)}catch(e){return n.ConfigManager.log("error","Error getting investigation cache:",e),[]}}async incrementRetryCount(e){try{const t=await this.getFromCache(e);t&&(t.retry_count=(t.retry_count||0)+1,await this.addToCache(t))}catch(e){throw n.ConfigManager.log("error","Error incrementing retry count:",e),e}}}u.CACHE_PREFIX="larvitar_cache_",u.CACHE_INDEX_KEY="larvitar_cache_index";const d=new u;class h{constructor(e,t){this.pollingInterval=1e3,this.maxPollingInterval=5e3,this.maxPollingAttempts=30,this.exponentialMultiplier=1.2,this.authManager=e,this.workSessionManager=t}async createSearchRequest(e){const t=n.ConfigManager.getSelectorSearchApiUrl("create"),a={selector_type:e.selectorType,selector_value:e.selectorValue,action_type:e.actionType,investigation_id:e.investigationId,page_url:e.pageUrl,page_title:e.pageTitle,meta_data:{timestamp:(new Date).toISOString(),source:"chrome_extension"}};n.ConfigManager.log("info","[SelectorSearchService] Creating search request",{url:t,payload:a});const s=await this.authManager.makeAuthenticatedRequest(t,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(a)});if(!s.ok){const e=await s.text();throw new Error(`Failed to create search request: ${s.statusText} - ${e}`)}const o=await s.json();if(n.ConfigManager.log("info","[SelectorSearchService] API Response received",{status:o.status,hasData:!!o.data,dataId:o.data?.id,fullResponse:o}),"success"!==o.status||!o.data?.id)throw n.ConfigManager.log("error","[SelectorSearchService] Invalid response structure",{expectedStructure:'SelectorSearchResponse with status="success" and data.id',actualResponse:o}),new Error(`Invalid response from search API: ${JSON.stringify(o)}`);return await this.storeRequestId(o.data.id,{selectorValue:e.selectorValue,selectorType:e.selectorType,actionType:e.actionType,createdAt:(new Date).toISOString()}),{id:o.data.id}}async getSearchStatus(e){const t=n.ConfigManager.getSelectorSearchApiUrl("get",e);n.ConfigManager.log("info","[SelectorSearchService] Getting search status",{requestId:e,url:t});const a=await this.authManager.makeAuthenticatedRequest(t,{method:"GET"});if(!a.ok){const e=await a.text();throw new Error(`Failed to get search status: ${a.statusText} - ${e}`)}return await a.json()}async pollForResults(e){let t=this.pollingInterval,a=0;for(n.ConfigManager.log("info","[SelectorSearchService] Starting to poll for results",{requestId:e});a<this.maxPollingAttempts;){a++;try{const s=await this.getSearchStatus(e);if(n.ConfigManager.log("info",`[SelectorSearchService] Poll attempt ${a}/${this.maxPollingAttempts}`,{status:s.status,requestId:e}),"completed"===s.status){if(!s.result_data)throw new Error("Search completed but no result data available");if(!s.result_data.success)throw new Error(s.result_data.error||"Search failed");return n.ConfigManager.log("info","[SelectorSearchService] Search completed successfully",{requestId:e,resultData:s.result_data}),s.result_data}if("failed"===s.status){const e=!1===s.result_data?.success?s.result_data.error:"Search failed";throw new Error(e)}a<this.maxPollingAttempts&&(await this.sleep(t),t=Math.min(t*this.exponentialMultiplier,this.maxPollingInterval))}catch(e){if(a<this.maxPollingAttempts&&e instanceof Error&&(e.message.includes("network")||e.message.includes("fetch"))){n.ConfigManager.log("warn","[SelectorSearchService] Network error during polling, retrying",{error:e.message,attempt:a}),await this.sleep(t);continue}throw e}}throw new Error("Search request timed out after 30 seconds")}async performSearch(e){try{const t=e.investigationId||await this.getActiveInvestigationId();await this.showNotification({title:"Selector Search Started",message:`Searching ${e.selectorValue}...`,type:"info"});const{id:a}=await this.createSearchRequest({selectorValue:e.selectorValue,selectorType:e.selectorType,actionType:e.actionType,investigationId:t,pageUrl:e.pageUrl,pageTitle:e.pageTitle});n.ConfigManager.log("info","[SelectorSearchService] Search request created",{requestId:a});const s=await this.pollForResults(a);return t?await this.showNotification({title:"Search Complete",message:"IOCs automatically added to investigation",type:"success",requestId:a}):await this.showNotification({title:"Search Complete",message:"Click to view results",type:"success",requestId:a}),s}catch(e){throw n.ConfigManager.log("error","[SelectorSearchService] Search failed",e),await this.showNotification({title:"Search Failed",message:e instanceof Error?e.message:"Unknown error occurred",type:"error"}),e}}async getActiveInvestigationId(){return this.workSessionManager.getCurrentInvestigationId()||void 0}async storeRequestId(e,t){const{recentSearches:a=[]}=await chrome.storage.local.get("recentSearches"),s=[{requestId:e,...t},...a.filter(t=>t.requestId!==e)].slice(0,50);await chrome.storage.local.set({recentSearches:s})}async showNotification(e){const t=e.requestId?`selector-search-${e.requestId}`:`selector-search-${Date.now()}`;return await chrome.notifications.create(t,{type:"basic",iconUrl:{info:"icons/icon48.png",success:"icons/icon48.png",error:"icons/icon48.png"}[e.type],title:e.title,message:e.message,priority:"error"===e.type?2:1}),t}sleep(e){return new Promise(t=>setTimeout(t,e))}async getRecentSearches(){const{recentSearches:e=[]}=await chrome.storage.local.get("recentSearches");return e}async clearRecentSearches(){await chrome.storage.local.remove("recentSearches")}}let m=null;function f(){if(!m)throw new Error("SelectorSearchService not initialized");return m}function p(e,t,s){if(console.log("[Messaging] 📨 Runtime message received:",{message:e,sender:t,hasAction:"action"in e,hasType:"type"in e,messageKeys:Object.keys(e||{}),action:e.action,type:e.type}),"updateEngagement"===e.action&&console.log("[Messaging] 🎯 FOUND updateEngagement message!",e),"action"in e){const a=e.action;return console.log("[Messaging] 🎯 Detected message with action:",a),function(e){const t=["capturePage","createBookmark","getBookmarks","updateSettings","getSettings","syncData","submitBulkData","submitURL","submitIOC","submitScreenshot","submitNote","getCacheStats","clearCache","startWorkSession","getCurrentSession","endWorkSession","getInvestigationCollaborators","getAllActiveSessions","startURLTracking","stopURLTracking","updateEngagement","getTrackingStatus","forceSubmission","manualTrackingStart","debugTabListeners","contentScriptReady"],a=t.includes(e);return console.log("[Messaging] 🔍 isDataAction check:",{action:e,result:a,allDataActions:t}),a}(a)?(console.log("[Messaging] ✅ Routing to data message handler for action:",a),function(e,t,a){console.log("[Messaging] handleDataMessage called with action:",e.action);(async()=>{try{console.log("[Messaging] handleAsync started for data action:",e.action),n.ConfigManager.log("info","Handling data message:",{action:e.action});let s={success:!1,error:"Unknown data action"};switch(e.action){case"capturePage":if(!e.pageData){s={success:!1,error:"Missing page data"};break}s={success:!0,data:await i.dataManager.capturePage(e.pageData)};break;case"createBookmark":if(!e.bookmarkData){s={success:!1,error:"Missing bookmark data"};break}s={success:!0,data:await i.dataManager.createBookmark(e.bookmarkData)};break;case"getBookmarks":s={success:!0,data:await i.dataManager.getBookmarks(e.params||{})};break;case"updateSettings":if(!e.settingsData){s={success:!1,error:"Missing settings data"};break}s={success:!0,data:await i.dataManager.updateSettings(e.settingsData)};break;case"getSettings":s={success:!0,data:await i.dataManager.getSettings()};break;case"syncData":s={success:!0,data:await i.dataManager.syncData(e.syncData||{})};break;case"submitBulkData":if(!e.bulkData){s={success:!1,error:"Missing bulk data"};break}s={success:!0,data:await i.dataManager.submitBulkData(e.bulkData)};break;case"submitURL":if(!e.urlData){s={success:!1,error:"Missing URL data"};break}s={success:!0,data:await i.dataManager.submitURL(e.urlData)};break;case"submitIOC":if(!e.iocData){s={success:!1,error:"Missing IOC data"};break}s={success:!0,data:await i.dataManager.submitIOC(e.iocData)};break;case"submitScreenshot":if(!e.screenshotData){s={success:!1,error:"Missing screenshot data"};break}s={success:!0,data:await i.dataManager.submitScreenshot(e.screenshotData)};break;case"submitNote":if(!e.noteData){s={success:!1,error:"Missing note data"};break}s={success:!0,data:await i.dataManager.submitNote(e.noteData)};break;case"getCacheStats":s={success:!0,data:await d.getCacheStats()};break;case"clearCache":const t=e.clearOptions||{clearAll:!1};s={success:!0,data:await d.clearCache(t)};break;case"startWorkSession":if(!e.investigationId){s={success:!1,error:"Missing investigation ID"};break}s={success:!0,data:await c.workSessionManager.startWorkSession(e.investigationId)};break;case"getCurrentSession":s={success:!0,data:await c.workSessionManager.getCurrentSession()};break;case"endWorkSession":try{g&&(console.log("[Messaging] 📤 Finalizing and submitting URLs before ending session"),await g.finalizeAndSubmitAll())}catch(e){console.warn("[Messaging] ⚠️ finalizeAndSubmitAll failed (pre-session-end):",e)}await c.workSessionManager.endWorkSession(),s={success:!0};break;case"getInvestigationCollaborators":if(!e.investigationId){s={success:!1,error:"Missing investigation ID"};break}s={success:!0,data:await c.workSessionManager.getInvestigationCollaborators(e.investigationId)};break;case"getAllActiveSessions":s={success:!0,data:await c.workSessionManager.getAllActiveSessions()};break;case"updateEngagement":const n=a?.tab?.id;if(console.log("[Messaging] 📨 Received updateEngagement message from content script:",{tabId:n,url:e.url,hasUrlTrackingData:!!e.urlTrackingData,clickCount:e.urlTrackingData?.engagementData?.click_count,scrollCount:e.urlTrackingData?.engagementData?.scroll_count,senderTabId:n}),!e.urlTrackingData||!e.urlTrackingData.engagementData){console.error("[Messaging] ❌ updateEngagement: Missing urlTrackingData or engagementData",{hasTabId:!!n,hasUrl:!!e.url,hasUrlTrackingData:!!e.urlTrackingData,hasEngagementData:!!e.urlTrackingData?.engagementData,messageKeys:Object.keys(e)}),s={success:!1,error:"Missing engagement data"};break}if(!n){console.error("[Messaging] ❌ updateEngagement: No tab ID available from sender"),s={success:!1,error:"No tab ID available"};break}try{console.log("[Messaging] 🔄 Processing engagement update via URL registry:",{tabId:n,url:e.url,clickCount:e.urlTrackingData.engagementData.click_count,scrollCount:e.urlTrackingData.engagementData.scroll_count,focusTime:e.urlTrackingData.engagementData.focus_time,idleTime:e.urlTrackingData.engagementData.idle_time});const t=c.workSessionManager?.getCurrentInvestigationId();if(!t){console.warn("[Messaging] ⚠️ No active investigation - tracking data received but not saved"),s={success:!0,data:{acknowledged:!0,warning:"No active investigation"}};break}g&&g.updateEngagement(n,e.urlTrackingData),console.log("[Messaging] ✅ updateEngagement: Successfully processed engagement data via URL registry"),s={success:!0,data:{tabId:n,acknowledged:!0,investigationId:t,dataReceived:{clicks:e.urlTrackingData.engagementData.click_count,scrolls:e.urlTrackingData.engagementData.scroll_count}}}}catch(e){console.error("[Messaging] ❌ updateEngagement: Error processing data:",e),s={success:!1,error:"Failed to process engagement data"}}break;case"getTrackingStatus":try{if(!g){s={success:!0,data:{isEnabled:!1,pendingURLs:0,queuedURLs:0,activeInvestigation:null,approach:"content_script",error:"URL registry not initialized"}};break}s={success:!0,data:g.getTrackingStatus()}}catch(e){console.error("[Messaging] ❌ Error getting tracking status:",e),s={success:!1,error:e.message||"Failed to get tracking status"}}break;case"forceSubmission":try{if(console.log("[Messaging] 📤 Force submission requested via URL registry"),!g){s={success:!1,error:"URL registry not initialized"};break}await g.forceSubmission(),s={success:!0,data:{message:"Force submission completed"}}}catch(e){console.error("[Messaging] ❌ Force submission failed:",e),s={success:!1,error:e.message||"Force submission failed"}}break;case"manualTrackingStart":if(console.log("[Messaging] 🔧 Manual tracking start requested:",{tabId:e.tabId,url:e.url,title:e.title}),!e.tabId||!e.url){console.error("[Messaging] ❌ Missing tabId or URL for manual start"),s={success:!1,error:"Missing tabId or URL"};break}try{console.log("[Messaging] ✅ Manual tracking acknowledged - content script handles tracking"),s={success:!0,data:{message:"Content script handles tracking automatically"}}}catch(e){console.error("[Messaging] ❌ Manual tracking acknowledgment failed:",e),s={success:!1,error:e.message||"Manual tracking failed"}}break;case"debugTabListeners":console.log("[Messaging] 🔧 Debug tab listeners requested");try{const e={approach:"content_script",backgroundTrackerEnabled:!1,activeInvestigation:c.workSessionManager?.getCurrentInvestigationId(),message:"Using content script approach - no background tab listeners"};console.log("[Messaging] ✅ Debug info for content script approach:",e),s={success:!0,data:e}}catch(e){console.error("[Messaging] ❌ Tab listener debug failed:",e),s={success:!1,error:e.message||"Debug failed"}}break;case"contentScriptReady":const o=a?.tab?.id;console.log("[Messaging] 🚀 Content script ready notification:",{tabId:o,url:e.url,title:e.title,senderTabId:o});const r=c.workSessionManager?.getCurrentInvestigationId();if(r)if(o&&e.url&&g)try{g.registerURL(o,e.url,e.title||"Untitled"),console.log("[Messaging] ✅ URL registered for tracking in registry")}catch(e){console.warn("[Messaging] ⚠️ Failed to register URL:",e)}else console.warn("[Messaging] ⚠️ Cannot register URL - missing tab ID or URL:",{hasTabId:!!o,hasUrl:!!e.url,hasRegistry:!!g});else console.log("[Messaging] ⏸️ Skipping URL registration - no active investigation");s={success:!0,data:{acknowledged:!0,tabId:o}};break;default:console.warn("[Messaging] Unknown data action:",e.action),s={success:!1,error:`Unknown data action: ${e.action}`}}console.log("[Messaging] Data action completed:",{action:e.action,success:s.success}),t(s)}catch(e){console.error("[Messaging] Data action error:",e),n.ConfigManager.log("error","Data message handling error:",e),t({success:!1,error:e.message||"Data operation failed"})}})()}(e,s,t),!0):(console.log("[Messaging] 🔀 Routing to auth message handler for action:",a),function(e,t){console.log("[Messaging] handleAuthMessage called with action:",e.action);console.log("[Messaging] About to call handleAsync"),(async()=>{try{console.log("[Messaging] handleAsync started for action:",e.action),n.ConfigManager.log("info","Handling auth message:",{action:e.action});let a={success:!1,error:"Unknown auth action"};switch(e.action){case"register":if(!(e.email&&e.password&&e.firstName&&e.lastName)){a={success:!1,error:"Missing required registration fields"};break}a={success:!0,data:await r.register(e.email,e.password,e.firstName,e.lastName)};break;case"login":if(!e.email||!e.password){a={success:!1,error:"Missing email or password"};break}a={success:!0,data:await r.login(e.email,e.password)};break;case"logout":await r.logout(e.logoutAll),a={success:!0};break;case"checkAuth":const t=await r.isAuthenticated(),s=await r.getCurrentUser();let o,i=!1;if(t)try{const e=await r.getMFAStatus();i=!0,o=e.current_aal}catch(e){}a={success:!0,authenticated:t,user:s||void 0,hasSession:i,aal:o};break;case"verifySession":a={success:!0,valid:await r.verifySession()};break;case"refreshToken":a={success:!0,data:{access_token:await r.refreshToken()}};break;case"makeRequest":if(!e.url){a={success:!1,error:"Missing URL for request"};break}const c=await r.makeAuthenticatedRequest(e.url,e.options),l=await c.json();a={success:c.ok,data:l,status:c.status};break;case"getMFAStatus":try{console.log("🔍 [MFA-STATUS] Starting MFA status check...");const e=await r.getValidToken();if(console.log("🔑 [MFA-STATUS] Token available:",!!e),!e){console.error("❌ [MFA-STATUS] No valid token for MFA status check"),a={success:!1,error:"No authentication token"};break}console.log("📡 [MFA-STATUS] Making authenticated status request...");const t=await r.getMFAStatus();console.log("✅ [MFA-STATUS] Status request completed successfully"),a={success:!0,data:t}}catch(e){console.error("❌ [MFA-STATUS] Error:",e),a={success:!1,error:e.message}}break;case"enrollMFA":a={success:!0,data:await r.enrollMFA(e.factorType??"totp",e.friendlyName)};break;case"createChallenge":if(!e.factorId){a={success:!1,error:"Missing factorId"};break}a={success:!0,data:await r.createChallenge(e.factorId)};break;case"verifyMFA":if(!e.factorId||!e.challengeId||!e.code){a={success:!1,error:"Missing required parameters"};break}const g=await r.verifyMFA(e.factorId,e.challengeId,e.code);if(g.access_token&&g.session_id){const e={access_token:g.access_token,refresh_token:g.refresh_token,session_id:g.session_id,expires_in:g.expires_in,token_type:g.token_type,user:g.user};await r.storeAuthData(e),n.ConfigManager.log("info","Updated authentication data after MFA verification",{newSessionId:g.session_id,aal:g.aal})}a={success:!0,data:g};break;case"listMFAFactors":a={success:!0,data:await r.listFactors()};break;case"unenrollMFA":if(!e.factorId){a={success:!1,error:"Missing factorId"};break}await r.unenrollMFA(e.factorId),a={success:!0};break;default:a={success:!1,error:"Unknown auth action"}}console.log("[Messaging] Sending response:",a),t(a)}catch(e){console.log("[Messaging] Auth handler error:",e),n.ConfigManager.log("error","Auth message handler error:",e),t({success:!1,error:e.message||"Unknown error occurred"})}})(),console.log("[Messaging] handleAsync called")}(e,s),!0)}const o=e;switch(console.log("[Messaging] Treating as extension message with type:",o.type),o.type){case"GET_EXTENSION_STATUS":!async function(e){try{const{getStorageData:t}=await Promise.resolve().then(a.bind(a,892));e({success:!0,data:{isEnabled:(await t(["isExtensionEnabled"])).isExtensionEnabled}})}catch(t){console.error("[Messaging] Error getting extension status:",t),e({success:!1,error:"Failed to get extension status"})}}(s);break;case"TOGGLE_EXTENSION":!async function(e,t){try{const{getStorageData:e,setStorageData:s}=await Promise.resolve().then(a.bind(a,892)),n=!(await e(["isExtensionEnabled"])).isExtensionEnabled;await s({isExtensionEnabled:n}),t({success:!0,data:{isEnabled:n}})}catch(e){console.error("[Messaging] Error toggling extension:",e),t({success:!1,error:"Failed to toggle extension"})}}(o.payload,s);break;case"getExtensionStatus":return U.getExtensionStatus(e.forceRefresh).then(e=>s({success:!0,data:e})),!0;case"getAuthServiceStatus":return U.getAuthServiceStatus().then(e=>s({success:!0,data:e})),!0;case"getComprehensiveStatus":return U.getComprehensiveStatus().then(e=>s({success:!0,data:e})),!0;case"testConnectivity":return U.testConnectivity().then(e=>s({success:!0,data:e})),!0;case"startMonitoring":U.startConnectionMonitoring(e.interval),s({success:!0,message:"Monitoring started"});break;case"stopMonitoring":U.stopConnectionMonitoring(),s({success:!0,message:"Monitoring stopped"});break;case"clearStatusCache":U.clearCache(),s({success:!0,message:"Status cache cleared"});break;case"testContentScript":!async function(e){try{console.log("[Messaging] 🧪 Testing content script injection...");const t=await chrome.tabs.query({active:!0,currentWindow:!0});if(0===t.length||!t[0].id)return void e({success:!1,error:"No active tab found"});const a=t[0].id;console.log("[Messaging] 🎯 Testing content script on tab:",a);const s=await async function(e){try{const t=await chrome.tabs.sendMessage(e,{type:"TEST_CONTENT_SCRIPT"});return console.log("[Messaging] Message sent to content script:",{tabId:e,response:t}),t}catch(e){throw console.error("[Messaging] Error sending message to content script:",e),e}}(a);console.log("[Messaging] ✅ Content script test response:",s),e({success:!0,data:s})}catch(t){console.error("[Messaging] ❌ Content script test failed:",t),e({success:!1,error:t instanceof Error?t.message:"Content script test failed"})}}(s);break;case"testURLTrackerInjection":!async function(e){try{console.log("[Messaging] 🧪 Testing content script approach..."),console.log("[Messaging] ✅ Content script approach - no injection needed"),e({success:!0,data:{message:"Content script approach - tracking loads automatically",approach:"content_script"}})}catch(t){console.error("[Messaging] ❌ Content script test failed:",t),e({success:!1,error:t instanceof Error?t.message:"Content script test failed"})}}(s);break;case"ANALYZE_SELECTOR":(async function(e,t){console.log("[Messaging] 🚀 handleAnalyzeSelector CALLED",{payload:e});try{const{agentId:a,selectorType:s,selectorValue:n,pageUrl:o,pageTitle:r}=e;if(!a||!s||!n)return void t({success:!1,error:"Missing required parameters for selector analysis"});const i=f(),l=c.workSessionManager.getCurrentInvestigationId(),{id:g}=await i.createSearchRequest({selectorValue:n,selectorType:s,actionType:a,investigationId:l||void 0,pageUrl:o,pageTitle:r});console.log("[Messaging] ✅ Selector search request created:",g),i.pollForResults(g).then(e=>{console.log("[Messaging] ✅ Polling completed for request:",g,e),l?i.showNotification({title:"Search Complete",message:"IOCs automatically added to investigation",type:"success",requestId:g}):i.showNotification({title:"Search Complete",message:"Click to view results",type:"success",requestId:g})}).catch(e=>{console.error("[Messaging] ❌ Polling failed for request:",g,e),i.showNotification({title:"Search Failed",message:e instanceof Error?e.message:"Unknown error",type:"error"})}),t({success:!0,data:{message:"Selector search request created successfully",selector:n,action:a,request_id:g,status:"pending"}})}catch(e){console.error("[Messaging] ❌ Selector analysis error:",e),t({success:!1,error:e instanceof Error?e.message:"Selector analysis failed"})}})(o.payload,s).catch(e=>{console.error("[Messaging] ❌ ANALYZE_SELECTOR handler error:",e),s({success:!1,error:e instanceof Error?e.message:"Failed to analyze selector"})});break;case"GET_SEARCH_STATUS":(async function(e,t){try{const{requestId:a}=e;if(!a)return void t({success:!1,error:"Missing requestId parameter"});const s=f();t({success:!0,data:await s.getSearchStatus(a)})}catch(e){console.error("[Messaging] ❌ Get search status error:",e),t({success:!1,error:e instanceof Error?e.message:"Failed to get search status"})}})(o.payload,s).catch(e=>{console.error("[Messaging] ❌ GET_SEARCH_STATUS handler error:",e),s({success:!1,error:e instanceof Error?e.message:"Failed to get search status"})});break;case"GET_SEARCH_RESULTS":(async function(e,t){try{const{requestId:a}=e;if(!a)return void t({success:!1,error:"Missing requestId parameter"});const s=f(),n=await s.getSearchStatus(a);if("completed"!==n.status)return void t({success:!1,error:`Search is not completed yet. Current status: ${n.status}`});if(!n.result_data)return void t({success:!1,error:"No result data available"});t({success:!0,data:{searchRequest:n,results:n.result_data}})}catch(e){console.error("[Messaging] ❌ Get search results error:",e),t({success:!1,error:e instanceof Error?e.message:"Failed to get search results"})}})(o.payload,s).catch(e=>{console.error("[Messaging] ❌ GET_SEARCH_RESULTS handler error:",e),s({success:!1,error:e instanceof Error?e.message:"Failed to get search results"})});break;case"LIST_RECENT_SEARCHES":(async function(e){try{const t=f(),a=await t.getRecentSearches();e({success:!0,data:{searches:a,count:a.length}})}catch(t){console.error("[Messaging] ❌ List recent searches error:",t),e({success:!1,error:t instanceof Error?t.message:"Failed to list recent searches"})}})(s).catch(e=>{console.error("[Messaging] ❌ LIST_RECENT_SEARCHES handler error:",e),s({success:!1,error:e instanceof Error?e.message:"Failed to list recent searches"})});break;default:console.warn("[Messaging] Unknown message type:",o.type),s({success:!1,error:`Unknown message type: ${o.type}`})}return!0}function w(e,t,a){console.log("[Messaging] External message received:",{message:e,sender:t}),a({success:!1,error:"External messages not supported"})}const y="larvitar-capture-selection",v="larvitar-add-note",k="larvitar-add-note-selection",M="larvitar-ai-agent-search",_="larvitar-ai-agent-thinking",b="larvitar-ai-agent-research";async function S(e,t){try{if(!t||!t.id)return void n.ConfigManager.log("warn","Context menu clicked but no valid tab found");if(n.ConfigManager.log("info","Context menu clicked",{menuItemId:e.menuItemId,pageUrl:e.pageUrl,linkUrl:e.linkUrl,selectionText:e.selectionText}),!await r.isAuthenticated())return void await chrome.notifications.create({type:"basic",iconUrl:"icons/icon48.png",title:"EdgeRun.Ai",message:"Please login to use investigation features"});switch(e.menuItemId){case y:await async function(e,t){try{n.ConfigManager.log("info","Handling selection capture from context menu");const a=e.selectionText||"";if(!a.trim())return void n.ConfigManager.log("warn","No text selected for capture");const s={url:e.pageUrl||t.url||"",title:t.title||"Untitled Page",domain:e.pageUrl?new URL(e.pageUrl).hostname:"",timestamp:(new Date).toISOString(),metadata:{selected_text:a,selection_length:a.length,context_menu_capture:!0,capture_type:"selection",tab_id:t.id}},o=await i.dataManager.capturePage(s);await chrome.notifications.create({type:"basic",iconUrl:"icons/icon48.png",title:"Selection Captured",message:`Text selection captured as evidence (${a.length} chars)`}),n.ConfigManager.log("info","Selection capture completed from context menu",{captureId:o.id,selectionLength:a.length})}catch(e){throw n.ConfigManager.log("error","Selection capture failed from context menu:",e),e}}(e,t);break;case v:await async function(e,t){try{n.ConfigManager.log("info","Handling add note from context menu"),await chrome.scripting.executeScript({target:{tabId:t.id},func:C,args:[!1,""]}),n.ConfigManager.log("info","Note widget injected successfully")}catch(e){n.ConfigManager.log("error","Failed to inject note widget:",e),await chrome.notifications.create({type:"basic",iconUrl:"icons/icon48.png",title:"EdgeRun.Ai - Error",message:"Failed to open note interface"})}}(0,t);break;case k:await async function(e,t){try{n.ConfigManager.log("info","Handling add note with selection from context menu");const a=e.selectionText||"";await chrome.scripting.executeScript({target:{tabId:t.id},func:C,args:[!0,a]}),n.ConfigManager.log("info","Note widget with selection injected successfully",{selectionLength:a.length})}catch(e){n.ConfigManager.log("error","Failed to inject note widget with selection:",e),await chrome.notifications.create({type:"basic",iconUrl:"icons/icon48.png",title:"EdgeRun.Ai - Error",message:"Failed to open note interface"})}}(e,t);break;case M:await E(e,t,"osint");break;case _:await E(e,t,"threat-intel");break;case b:await E(e,t,"forensics");break;default:n.ConfigManager.log("warn","Unknown context menu item clicked:",e.menuItemId)}}catch(e){n.ConfigManager.log("error","Error handling context menu click:",e),await chrome.notifications.create({type:"basic",iconUrl:"icons/icon48.png",title:"EdgeRun.Ai - Error",message:"Failed to process investigation action"})}}function C(e,t){if(document.getElementById("larvitar-note-widget"))return;const a=document.createElement("div");a.id="larvitar-note-widget",a.innerHTML=`\n    <div style="position: fixed; top: 20px; right: 20px; z-index: 10000; \n         background: white; border: 2px solid #007bff; border-radius: 8px; padding: 15px; width: 350px;\n         box-shadow: 0 4px 12px rgba(0,0,0,0.3); font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">\n      <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">\n        <h4 style="margin: 0; color: #333;">Investigation Note</h4>\n        <button id="larvitar-close-widget" style="background: none; border: none; font-size: 18px; cursor: pointer; color: #666;">&times;</button>\n      </div>\n      ${e?`<div style="margin-bottom: 10px; padding: 8px; background: #f8f9fa; border-radius: 4px; font-size: 12px; border-left: 3px solid #007bff;">\n        <strong>Selected text:</strong><br>\n        <span style="font-style: italic;">"${t.substring(0,100)}${t.length>100?"...":""}"</span>\n      </div>`:""}\n      <textarea id="larvitar-note-content" placeholder="Enter your observation, analysis, or findings..." \n                rows="4" style="width: 100%; margin-bottom: 10px; padding: 8px; border: 1px solid #ddd; border-radius: 4px; resize: vertical; font-size: 14px;"></textarea>\n      <select id="larvitar-note-type" style="margin-bottom: 10px; padding: 6px; border: 1px solid #ddd; border-radius: 4px; width: 100%;">\n        <option value="observation">Observation</option>\n        <option value="analysis">Analysis</option>\n        <option value="hypothesis">Hypothesis</option>\n        <option value="conclusion">Conclusion</option>\n        <option value="todo">TODO</option>\n        <option value="reference">Reference</option>\n      </select>\n      <div style="margin-bottom: 10px;">\n        <label style="display: flex; align-items: center; font-size: 14px;">\n          <input type="checkbox" id="larvitar-is-important" style="margin-right: 6px;"> \n          Mark as Important\n        </label>\n      </div>\n      <div style="display: flex; gap: 8px;">\n        <button id="larvitar-save-note" style="flex: 1; background: #007bff; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer; font-size: 14px;">Save Note</button>\n        <button id="larvitar-cancel-note" style="background: #6c757d; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer; font-size: 14px;">Cancel</button>\n      </div>\n    </div>\n  `,document.body.appendChild(a);const s=document.getElementById("larvitar-close-widget"),n=document.getElementById("larvitar-cancel-note"),o=document.getElementById("larvitar-save-note"),r=()=>a.remove();s?.addEventListener("click",r),n?.addEventListener("click",r),o?.addEventListener("click",async()=>{const a=document.getElementById("larvitar-note-content")?.value.trim(),s=document.getElementById("larvitar-note-type")?.value,n=document.getElementById("larvitar-is-important")?.checked;if(a)if(a.length>1e4)alert("Note content is too long (maximum 10,000 characters)");else try{const o={content:a,note_type:s,selected_text:e&&t.length<=1e3?t:void 0,is_important:n,metadata:{source:"context_menu",page_url:window.location.href,page_title:document.title,timestamp:(new Date).toISOString(),user_agent:navigator.userAgent}};chrome.runtime.sendMessage({action:"submitNote",noteData:o},e=>{if(chrome.runtime.lastError)return console.error("Failed to save note:",chrome.runtime.lastError),void alert("Failed to save note. Please try again.");if(e?.success){const e=document.createElement("div");e.style.cssText="\n            position: fixed; top: 20px; left: 50%; transform: translateX(-50%);\n            background: #28a745; color: white; padding: 10px 20px; border-radius: 4px; z-index: 10001;\n            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;\n          ",e.textContent="Note saved successfully!",document.body.appendChild(e),setTimeout(()=>e.remove(),3e3),r()}else alert("Failed to save note: "+(e?.error||"Unknown error"))})}catch(e){console.error("Failed to save note:",e),alert("Failed to save note. Please try again.")}else alert("Please enter note content")});const i=document.getElementById("larvitar-note-content");i?.focus()}async function E(e,t,a){try{n.ConfigManager.log("info","Handling AI agent selection from context menu",{agentId:a,selectionText:e.selectionText});const s=e.selectionText||"";if(!s.trim())return void n.ConfigManager.log("warn","No text selected for AI agent");await chrome.tabs.sendMessage(t.id,{type:"ANALYZE_SELECTOR_FROM_CONTEXT",payload:{agentId:a,selectorValue:s,pageUrl:e.pageUrl||t.url||"",pageTitle:t.title||"Untitled Page"}}),n.ConfigManager.log("info","AI agent selection message sent to content script")}catch(e){n.ConfigManager.log("error","Failed to handle AI agent selection:",e),await chrome.notifications.create({type:"basic",iconUrl:"icons/icon48.png",title:"EdgeRun.Ai - Error",message:"Failed to process AI agent request"})}}const U=new class{constructor(e){this.lastStatusCheck=0,this.statusCache=null,this.cacheTimeout=3e4,this.monitoringInterval=null,this.authManager=e}async getExtensionStatus(e=!1){const t=Date.now();if(!e&&this.statusCache&&t-this.lastStatusCheck<this.cacheTimeout)return this.statusCache;try{const e=await fetch(n.ConfigManager.getFullApiUrl("/api/v1/chrome/status"),{method:"GET",headers:{"Content-Type":"application/json","X-Extension-ID":chrome.runtime.id||"unknown"}});if(!e.ok)throw new Error(`Status check failed: ${e.status}`);const a=await e.json();return this.statusCache={connected:!0,lastCheck:t,responseTime:Date.now()-t,data:a},this.lastStatusCheck=t,this.statusCache}catch(e){console.error("Extension status check failed:",e);const a={connected:!1,error:e.message,lastCheck:t,message:"Extension connection failed",data:{features:[],version:"unknown",status:"disconnected"}};return this.statusCache=a,this.lastStatusCheck=t,a}}async getAuthServiceStatus(){try{const e=await fetch(n.ConfigManager.getFullApiUrl("/api/v1/chrome/auth/status"),{method:"GET",headers:{"Content-Type":"application/json","X-Extension-ID":chrome.runtime.id||"unknown"}});if(!e.ok)throw new Error(`Auth service check failed: ${e.status}`);return{connected:!0,serviceType:"authentication",...await e.json()}}catch(e){return console.error("Auth service status check failed:",e),{connected:!1,serviceType:"authentication",error:e.message,message:"Authentication service unavailable"}}}async getComprehensiveStatus(){const[e,t]=await Promise.all([this.getExtensionStatus(),this.getAuthServiceStatus()]),a=await this.authManager.isAuthenticated(),s=await this.authManager.getCurrentUser();return{timestamp:Date.now(),extension:e,authentication:{...t,userAuthenticated:a,currentUser:s},overall:{healthy:e.connected&&t.connected,readyForOperations:e.connected&&t.connected&&a}}}startConnectionMonitoring(e=6e4){this.monitoringInterval&&clearInterval(this.monitoringInterval),this.monitoringInterval=setInterval(async()=>{try{const e=await this.getExtensionStatus(!0);chrome.runtime.sendMessage({type:"statusUpdate",status:e}).catch(()=>{}),console.log("Connection monitoring - Status:",e.connected)}catch(e){console.error("Connection monitoring error:",e)}},e)}stopConnectionMonitoring(){this.monitoringInterval&&(clearInterval(this.monitoringInterval),this.monitoringInterval=null)}clearCache(){this.statusCache=null,this.lastStatusCheck=0}async testConnectivity(){const e=Date.now();try{const t=await fetch(n.ConfigManager.getFullApiUrl("/api/v1/chrome/status"),{method:"GET",headers:{"Content-Type":"application/json","X-Extension-ID":chrome.runtime.id||"unknown"}}),a=Date.now()-e;return{success:t.ok,responseTime:a,status:t.status,statusText:t.statusText}}catch(t){return{success:!1,responseTime:Date.now()-e,error:t.message}}}}(r);!async function(){try{n.ConfigManager.log("info","Initializing Larvitar Chrome extension background script"),await(0,s.u)(),await async function(){try{n.ConfigManager.log("info","Initializing authentication feature"),await n.ConfigManager.loadEnvironmentPreference(),n.ConfigManager.log("info",`Auth feature initialized with environment: ${n.ConfigManager.getEnvironmentName()}`)}catch(e){throw n.ConfigManager.log("error","Failed to initialize auth feature:",e),e}}(),await(0,i.C)(r),await(0,c.I)(r),function(e,t){m||(m=new h(e,t))}(r,c.workSessionManager),await async function(){try{n.ConfigManager.log("info","Initializing Content Script URL Registry");const{dataManager:e}=await Promise.resolve().then(a.bind(a,908)),{workSessionManager:t}=await Promise.resolve().then(a.bind(a,943));g=new l(e,t),n.ConfigManager.log("info","Content Script URL Registry initialized successfully")}catch(e){throw n.ConfigManager.log("error","Failed to initialize Content Script URL Registry:",e),e}}(),await async function(){try{n.ConfigManager.log("info","Initializing context menu feature"),await chrome.contextMenus.removeAll(),await async function(){try{await chrome.contextMenus.create({id:y,title:"📝 Capture Selection as Evidence",contexts:["selection"],documentUrlPatterns:["http://*/*","https://*/*"]}),await chrome.contextMenus.create({id:"larvitar-separator-notes",type:"separator",contexts:["page","selection"]}),await chrome.contextMenus.create({id:v,title:"📝 Add Project Note",contexts:["page"],documentUrlPatterns:["http://*/*","https://*/*"]}),await chrome.contextMenus.create({id:k,title:"📝 Add Note About Selection",contexts:["selection"],documentUrlPatterns:["http://*/*","https://*/*"]}),await chrome.contextMenus.create({id:"larvitar-separator-ai-agents",type:"separator",contexts:["selection"]}),await chrome.contextMenus.create({id:M,title:"🔍 Search (Fast OSINT)",contexts:["selection"],documentUrlPatterns:["http://*/*","https://*/*"]}),await chrome.contextMenus.create({id:_,title:"🛡️ Thinking (Extended)",contexts:["selection"],documentUrlPatterns:["http://*/*","https://*/*"]}),await chrome.contextMenus.create({id:b,title:"🔬 Research (Deep)",contexts:["selection"],documentUrlPatterns:["http://*/*","https://*/*"]}),n.ConfigManager.log("info","Context menu items created successfully")}catch(e){throw n.ConfigManager.log("error","Error creating context menu items:",e),e}}(),chrome.contextMenus.onClicked.addListener(S),n.ConfigManager.log("info","Context menu feature initialized successfully")}catch(e){throw n.ConfigManager.log("error","Error initializing context menu feature:",e),e}}(),await async function(){console.log("[Messaging] Initializing messaging feature");try{chrome.runtime.onMessage.addListener(p),chrome.runtime.onMessageExternal.addListener(w),console.log("[Messaging] Messaging feature initialized successfully")}catch(e){throw console.error("[Messaging] Error initializing messaging feature:",e),e}}(),await async function(e){try{n.ConfigManager.log("info","Initializing status feature"),e.startConnectionMonitoring(),n.ConfigManager.log("info","Status feature initialized")}catch(e){throw n.ConfigManager.log("error","Failed to initialize status feature:",e),e}}(U),n.ConfigManager.log("info","All features initialized successfully")}catch(e){n.ConfigManager.log("error","Error initializing background script:",e)}}(),chrome.runtime.onStartup.addListener(async()=>{try{const e=await r.isAuthenticated();n.ConfigManager.log("info","Extension startup - Authenticated:",e),e&&(await r.verifySession()||(n.ConfigManager.log("warn","Session invalid on startup, clearing auth data"),await r.logout())),U.startConnectionMonitoring()}catch(e){n.ConfigManager.log("error","Startup auth check failed:",e)}}),chrome.runtime.onInstalled.addListener(async e=>{try{n.ConfigManager.log("info",`Extension installed/updated: ${e.reason}`),"install"===e.reason&&(await chrome.storage.local.clear(),n.ConfigManager.log("info","Fresh install - cleared storage")),U.startConnectionMonitoring()}catch(e){n.ConfigManager.log("error","Install handler error:",e)}}),chrome.notifications.onClicked.addListener(async e=>{try{if(e.startsWith("selector-search-")){const t=e.replace("selector-search-","");n.ConfigManager.log("info","Opening search results for request:",t),await chrome.storage.local.set({currentSearchRequestId:t});const a=await chrome.windows.getCurrent();chrome.sidePanel&&chrome.sidePanel.open&&a.id?await chrome.sidePanel.open({windowId:a.id}):await chrome.tabs.create({url:`selector-results.html?requestId=${t}`}),await chrome.notifications.clear(e)}}catch(e){n.ConfigManager.log("error","Notification click handler error:",e)}})})();